#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
MPFS settings validation script.
"""

import os

from argparse import ArgumentParser
from pprint import pprint

import mpfs.engine.process

ENVIRONMENT_FILE_PATH = '/etc/yandex/environment.type'
PACKAGE_FILE_PATH = '/etc/yandex/mpfs/package.type'


def print_settings(args):
    from mpfs.config import settings

    dpath = args.dpath.strip()
    if dpath.startswith('/'):
        dpath = dpath[1:]
    if dpath.endswith('/'):
        dpath = dpath[:-1]

    if not dpath:
        pprint(settings)
    else:
        subtree = settings.as_dict()
        for key in dpath.split('/'):
            subtree = subtree[key]
        pprint(subtree)


def validate_settings(_):
    import mpfs.config
    print 'OK'


def get_environment():
    with open(ENVIRONMENT_FILE_PATH) as fd:
        return fd.read().strip()


def get_package():
    with open(PACKAGE_FILE_PATH) as fd:
        return fd.read().strip()


def setup_env(environment, package):
    os.environ.update({
        'MPFS_PACKAGE': package,
        'MPFS_ENVIRONMENT': environment
    })


if __name__ == '__main__':

    mpfs.engine.process.seteuid()

    parser = ArgumentParser(description=__doc__)

    parser.add_argument('-p', choices=('disk', 'browser', 'platform'),
                        default=None,
                        help='Package type.'
                             ' Defaults to `cat %s`' % PACKAGE_FILE_PATH)
    parser.add_argument('-e', choices=('development', 'testing', 'prestable', 'production'),
                        default=None,
                        help='Environment type.'
                             ' Defaults to `cat %s`' % ENVIRONMENT_FILE_PATH)

    sub_parser = parser.add_subparsers()
    print_parser = sub_parser.add_parser('print', help='Print out settings')
    print_parser.set_defaults(func=print_settings)
    print_parser.add_argument('--dpath', default='',
                              help='Dictionary path like path/to/settings/sub/tree.'
                                   ' Defaults to ""')

    validate_parser = sub_parser.add_parser('validate',
                                            help='Check that settings are valid, if not - show error.')
    validate_parser.set_defaults(func=validate_settings)

    args = parser.parse_args()
    environment = args.e or get_environment()
    package = args.p or get_package()

    setup_env(environment, package)
    args.func(args)
