#!/usr/bin/python
# -*- coding: utf-8 -*-
import sys
import traceback
from optparse import OptionParser, Option

usage = "usage: sudo /usr/sbin/%prog -h"

option_list = (
    Option(
        '-f', '--file',
        action='store',
        dest='filename',
        type='string',
        help='file with serials'
    ),
)

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
log = mpfs.engine.process.get_error_log()

from mpfs.core.user.devices import sony
from mpfs.common.errors import ResourceExist

if __name__ == "__main__":
    if not options.filename:
        parser.print_help()
        sys.exit(0)
        
    with open(options.filename) as f:
        for line in f.read().split('\n'):
            serial = line.replace(' ', '')
            if serial:
                try:
                    sony.add_tablet_serial(serial)
                except ResourceExist, e:
                    log.error(e)
                    result = '%s already exists' % serial
                except Exception, e:
                    log.error(e)
                    log.error(traceback.format_exc())
                    result = '%s failed' % serial
                else:
                    result = '%s ok' % serial
                log.info(result)
                print result
            