#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
Скрипт менеджера стартующего пачку воркеров чистки.

За работой скрипта смотреть в логах.
Дополнительные настройки смотреть в: 'global_settings.yaml -> storage_cleaner'
"""
import time
import signal
from argparse import ArgumentParser

from mpfs.engine.process import setup_admin_script
setup_admin_script()
from mpfs.core.filesystem.cleaner.manager import StorageCleanerManager


def main(repeats=1, sleep_time=1):
    def signal_handler(*args):
        exit()
    signal.signal(signal.SIGINT, signal_handler)

    # это нужно, чтобы запускать менеджера чаще, чем 1 раз в минуту
    for i in xrange(repeats):
        StorageCleanerManager().run()
        # на последней итерации не спим
        if repeats - i - 1 > 0:
            time.sleep(sleep_time)


if __name__ == "__main__":
    parser = ArgumentParser(description=__doc__)
    parser.add_argument('worker', nargs='+', help='Для совместимости. Нужно передать любую строку.')
    parser.add_argument('-t', default=1, type=int, help='Cколько секунд ждать между повторениями.')
    parser.add_argument('-r', default=1, type=int, help='Cколько раз запускать воркер.')
    namespace = parser.parse_args()
    main(repeats=namespace.r, sleep_time=namespace.t)
