#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
Скрипт чистки stid-ов в сторадже.

За работой скрипта смотреть в логах.
Дополнительные настройки смотреть в: 'global_settings.yaml -> storage_cleaner'
"""
from argparse import ArgumentParser

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()

from mpfs.core.filesystem.cleaner.worker import StorageCleanerWorker


if __name__ == "__main__":
    parser = ArgumentParser(description=__doc__)
    parser.add_argument('input_stids', nargs='+', help='Список stid-ов')
    namespace = vars(parser.parse_args())
    input_stids = namespace['input_stids']

    # это нужно для поддержки старого режима с выбором типа воркера
    # тип воркера просто игнорируется
    if 'Worker' in input_stids[0]:
        input_stids = input_stids[1:]

    StorageCleanerWorker(input_stids).run()
