#!/usr/bin/python
# -*- coding: utf-8 -*-
import sys
import traceback

from optparse import OptionParser, Option

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()

from mpfs.config import settings
from mpfs.core.job_handlers.trash_clean import process_queue

log = mpfs.engine.process.get_default_log()
usage = "usage: sudo /usr/sbin/%prog -h"

option_list = (
    Option(
        '-p', '--period',
        action='store',
        type='int',
        dest='period',
        default=settings.system['system']['trash_autoclean_period'],
        help='period to processing (default %s)' % settings.system['system']['trash_autoclean_period']),
)

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()

if __name__ == "__main__":
    if settings.feature_toggles['start_clean_trash']:
        try:
            process_queue(period=options.period)
        except Exception:
            log.error(traceback.format_exc())
            # при ошибке сообщаем базинге, что нужен ретрай
            sys.exit(50)
    else:
        log.info("Trash clean disabled in config")
        sys.exit(0)
