#!/usr/bin/python
# -*- coding: utf-8 -*-
import json
import base64
import struct

from optparse import OptionParser, Option

usage = "usage: sudo /usr/sbin/%prog -h"
    
option_list = (
    Option(
        '-i', '--id',
        action='store',
        dest='item_id',
        type='string',
        default=None,
        help='Specify item _id'
    ),
    Option(
        '-p', '--parent',
        action='store',
        dest='parent_id',
        type='string',
        default=None,
        help='Specify parent _id'
    ),
    Option(
        '-u', '--uid',
        action='store',
        dest='uid',
        type='string',
        default=None,
        help='Specify uid'
    ),
    Option(
        '-c', '--collection',
        action='store',
        dest='collection',
        default=None,
        help="Specify collection",
    ),
    Option(
        '-d', '--database',
        action='store',
        dest='database',
        default='mpfs',
        help="Specify database",
    ),
)

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()

import mpfs.engine.process
mpfs.engine.process.setup_anyone_script()

from mpfs.metastorage.mongo.util import decompress_data
from mpfs.metastorage.mongo.binary import ObjectId, InvalidId
from mpfs.metastorage.mongo.collections.meta import MPFSMongoCollectionsMeta

conn = mpfs.engine.process.dbctl().connection()
coll_meta = MPFSMongoCollectionsMeta()
    

def hid2hid(hid):
    y = [' ', '\x00', '\x00', '\x00']
    for i in range(32):
        y.append(hid[i])
    y = struct.pack('cccccccccccccccccccccccccccccccccccc', y[0], y[1], y[2], y[3], y[4], y[5], y[6], y[7], y[8], y[9], y[10], y[11], y[12], y[13], y[14], y[15], y[16], y[17], y[18], y[19], y[20], y[21], y[22], y[23], y[24], y[25], y[26], y[27], y[28], y[29], y[30], y[31], y[32], y[33], y[34], y[35])
    return(base64.b64encode(y))

def decompress_item(item):
    if not item:
        try:
            item = conn[options.database][options.collection].find_one({'_id':ObjectId(options.item_id)})
        except InvalidId:
            pass

    if item:
        unzip(item)
    else:
        print 'cannot find _id "%s" in "%s"' % (options.item_id, options.collection)

def print_item():
    item = conn[options.database][options.collection].find_one({'_id':options.item_id})
    decompress_item(item)

def print_children():
    for item in conn[options.database][options.collection].find({'parent' : options.parent_id}):
        decompress_item(item)

def print_uid():
    for item in conn[options.database][options.collection].find({'uid':options.uid}):
        unzip(item)
        print ""

def unzip(item):
    try:
        zdata = item.pop('zdata')
    except KeyError:
        try:
            item['data'] = decompress_data(item['data'])
        except Exception:
            if options.collection in ('queue', 'queue_active', 'queue_index',):
                item['data'] = decompress_data(item.get('data', {}))
    else:
        if options.collection in ('user_data', 'trash', 'hidden_data', 'attach_data', 'narod_data', 'misc_data'):
            coll_object = coll_meta.get_collection_by_name(options.collection)
            
            item['data'] = coll_object._unzip_resource_data(
                item['type'],
                item.pop('data', {}),
                zdata
            )
        elif options.collection in ('changelog', 'browser', ):
            item['data'] = decompress_data(zdata)

    if 'hid' in item:
        item['hid_binary'] = hid2hid(item['hid'])

    if options.collection in ('browser', 'changelog'):
        item['_id'] = 'ObjectId: %s' % (item['_id'], )
        
    if 'dtime' in item:
        item['dtime'] = str(item['dtime'])

    print json.dumps(item, ensure_ascii=False, sort_keys=True, indent=4).encode('utf-8')


if __name__ == "__main__":
    if not options.collection:
        parser.error('specify collection')
    if not options.uid and not (options.item_id or options.parent_id):
        parser.error('specify uid or item id either parent id')
    
    if options.item_id:
        print_item()
    elif options.parent_id:
        print_children()
    elif options.uid:
        print_uid()
