#!/usr/bin/python
# -*- coding: utf-8 -*-
'''
Скрипт перегенерации превью видео.

Принимает на вход uid и path файла
Делает запрос на кладун и созраняет превью в базу для данного одного фалйа
Существующее превью помещает в deleted_stids
'''
import sys
import traceback
from argparse import ArgumentParser

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()

from mpfs.common import errors
from mpfs.core.services.previewer_service import Previewer
from mpfs.core.metastorage.control import regerate_video_info_fails
from mpfs.core import factory
from mpfs.core.address import Address
from mpfs.core.filesystem.resources.disk import MPFSFile


def regenerate_preview(uid, path, kladun_timeout=60):
    address = Address.Make(uid, path)
    resource = factory.get_resource(address.uid, address)
    if not isinstance(resource, MPFSFile):
        raise TypeError('Cant regenerate preview for %s' % resource.__class__.__name__)

    if regerate_video_info_fails.is_already_failed(resource.hid):
        return

    try:
        resource.regenerate_preview(timeout=kladun_timeout)
    except errors.APIError:
        regerate_video_info_fails.set_failed(resource.hid)
        raise


if __name__ == '__main__':
    parser = ArgumentParser(description='Regenerate preview')
    parser.add_argument('--uid', type=str, required=True, help='uid')
    parser.add_argument('--path', type=str, required=True, help='path')
    parser.add_argument('--timeout', type=int, default=60, help='kladun timeout (in seconds)')
    parser.add_argument('--verbose', action='store_true', help='DEPRECATED. No effect')
    parser.add_argument('--dry-run', action='store_true', help='DEPRECATED. No effect')
    parser.add_argument('--force', action='store_true', help='DEPRECATED. No effect')
    args = parser.parse_args()

    path = args.path
    if isinstance(path, str):
        path = path.decode('utf-8')

    try:
        regenerate_preview(args.uid, path, kladun_timeout=args.timeout)
    except Exception:
        print traceback.format_exc()
        sys.exit(1)
