# -*- coding: utf-8 -*-
"""
Зазиповывает стиды, чтоб воссоздать старые зазипованные файлы.
С флагом --make-old-previews запаковывает стиды превьюшек в previews и устанавливает их в pmid.

Использовать только по QA-шным пользователям и файлам, т.к. чистка мульки не проверяет файлы с зазипованными стидами.
"""
import os
os.environ['MPFS_PACKAGE'] = 'disk'
from optparse import OptionParser, Option

from mpfs.engine.process import setup_anyone_script, dbctl
setup_anyone_script()

from mpfs.metastorage.mongo.util import decompress_data, compress_data


def main(collection_name, uid, path, make_old_previews=False):
    collection = dbctl().database()[collection_name]

    item = collection.find_one({'uid': uid, 'key': path, 'type': 'file'})

    data = item['data']
    zdata = item['zdata']
    decompressed_zdata = decompress_data(zdata)

    decompressed_zdata['setprop'] = decompressed_zdata.get('setprop', {})
    for stid_data in data['stids']:
        if make_old_previews and stid_data['type'] == 'pmid':
            continue  # skip pmid
        decompressed_zdata['setprop'][stid_data['type']] = stid_data['stid']

    if make_old_previews and 'previews' not in decompressed_zdata and 'pmid' in data['stids']:
        pmid = data['stids']['pmid']
        decompressed_zdata['previews'] = \
            dict((size, pmid) for size in ('XXXL', 'XXL', 'XL', 'L', 'M', 'S', 'XS', 'XXS', 'XXXS'))

    zdata = compress_data(decompressed_zdata)
    collection.update({'uid': uid, "key": path, "type": "file"}, {'$set': {'zdata': zdata}, '$unset': {'data.stids': ''}})


option_list = (
    Option(
        '-c',
        '--collection',
        type='string',
        action='store',
        default='user_data',
        dest='collection',
        help='collection name',
    ),
    Option(
        '-u',
        '--uid',
        type='string',
        action='store',
        dest='uid',
        help='UID'
    ),
    Option(
        '-p',
        '--path',
        type='string',
        action='store',
        dest='path',
        help='path',
    ),
    Option(
        '--make-old-previews',
        action='store_true',
        dest='make_old_previews',
        help='zip pmid into old previews field',
        default=False
    ),
)

usage = "usage: %prog -f UIDS"
parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()

if __name__ == '__main__':
    main(options.collection, options.uid, options.path, options.make_old_previews)
