#!/usr/bin/python
# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Скрипт экспорта продуктов в Большой Биллинг

"""
import pprint
import sys
import time
import traceback
from optparse import OptionParser, Option

usage = "usage: sudo /usr/sbin/%prog -h"

option_list = (
    Option(
        '-p', '--product',
        action='store',
        dest='product',
        type='string',
        help='product id from catalog'
    ),
    Option(
        '-l', '--line',
        action='store',
        dest='line',
        type='string',
        help='product line from catalog'
    ),
)

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
log = mpfs.engine.process.get_error_log()

from mpfs.common.util import ctimestamp
from mpfs.core.billing.product import Product
from mpfs.core.billing.processing import marketing 

if __name__ == "__main__": 
    if not options.product and not options.line:
        parser.print_help()
        sys.exit(0)
        
    if options.product:
        pprint.pprint(
            marketing.product_export(
                Product(options.product), ctimestamp()
            )
        )
    elif options.line:
        pprint.pprint(
            marketing.line_export(
                options.line, ctimestamp()
            )
        )
  