#!/usr/bin/python
# -*- coding: utf-8 -*-
u"""
Добивка доступного пользователям места до 10ГБ методом добавления недостающих бонусных сервисов.
Ноги растут от туда -> https://jira.yandex-team.ru/browse/CHEMODAN-13926
"""
import multiprocessing
import optparse
import os
import sys
import traceback

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
log = mpfs.engine.process.get_default_log()

from mpfs.common.util import logger, iterdbuids
from mpfs.common.errors import StorageEmptyDiskInfo, StorageInitUser
from mpfs.core.billing.processing import pushthelimits


def target(uid):
    mpfs.engine.process.reset_cached()
    return uid, pushthelimits.pushto_10gb(uid)


def callback(result):
    uid, services = result
    log.info('UID %s: created %s services.' % (uid, repr(services.keys())))


def error_handler(uid, exception):
    if isinstance(exception, (StorageEmptyDiskInfo, StorageInitUser)):
        log.error('UID %s WARNING: %s: %s' % (uid, type(exception).__name__, exception))
    else:
        log.error('UID %s ERROR: %s %s\n%s' % (uid, type(exception).__name__, exception, traceback.format_exc()))


option_list = (
    optparse.Option('-f', '--file',
                    type='string', action='store',
                    dest='file', default='/tmp/mpfs-billing-make10gb.txt',
                    help='File where to store local uid cache. Default is "%default".'),
    optparse.Option('-p', '--processes',
                    type='int', action='store',
                    dest='processes', default=None,
                    help='Number of processes. Default is your CPU count: %d.' % multiprocessing.cpu_count()),
)


if __name__ == '__main__':
    parser = optparse.OptionParser(option_list=option_list, usage=__doc__)
    (options, args) = parser.parse_args()
    iterdbuids.run(target, callback, options.file, max_processes=options.processes, error_handler=error_handler)
