#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
Скрипт, выгружающий пользователей с конкретных replica sets
"""
import sys
import pymongo

from optparse import OptionParser, Option

import mpfs.engine.process
from mpfs.metastorage.postgres.query_executer import PGQueryExecuter

mpfs.engine.process.setup_anyone_script()

from mpfs.metastorage.mongo.rsclient import MPFSMongoReplicaSetClient
from mpfs.common.util import chunks, format_dict_table


class UserUidExportError(Exception):
    def __init__(self, uid):
        self.uid = uid

    def __str__(self):
        return 'No user info is found for uid %s' % str(self.uid)


class UidsExporter(object):
    def __init__(self):
        self._dbctl = None
        self._mongos_rs_hosts = None
        self._shards_rs_hosts = None

    @property
    def dbctl(self):
        if self._dbctl is None:
            self._dbctl = mpfs.engine.process.dbctl()
        return self._dbctl

    @property
    def shards_rs_hosts(self):
        if self._shards_rs_hosts is None:
            self._shards_rs_hosts = self.dbctl.mapper.rspool.get_all_shards_info()
        return self._shards_rs_hosts

    @staticmethod
    def get_rs_client(host, rs_name):
        return MPFSMongoReplicaSetClient(
            host,
            replicaSet=rs_name,
            read_preference=pymongo.ReadPreference.SECONDARY,
            socketTimeoutMS=120000,
            name=rs_name,
        )

    def filter_sharded_uids(self, uids):
        """Отфильтровываем шардированных пользователей"""
        result = []
        pg_query_executer = PGQueryExecuter()
        for uid in uids:
            if pg_query_executer.is_user_in_postgres(uid):
                result.append(uid)
        return result

    def get_uids_from_rs(self, rs_name, export_sharded=False):
        """Выгрузка uid-ов с RS"""
        if rs_name == 'pg':
            raise NotImplementedError("cant export from sharpei")
        raise KeyError("No such rs_name.")


if __name__ == "__main__":
    usage = """
    /usr/sbin/%prog RS_NAME_1 [RS_NAME_N] ... > uids.txt
    /usr/sbin/%prog -l
    """
    option_list = (
        Option(
            '-e', '--export-sharded',
            action='store_true',
            dest='export_sharded',
            help=u'Для mongos-их RS экспортировать смигрированных пользователей.',
        ),
        Option(
            '-l', '--list',
            action='store_true',
            dest='list',
            help=u'Показать список доступных RS.',
        ),
    )
    parser = OptionParser(usage, option_list=option_list)
    (options, rs_names) = parser.parse_args()

    exporter = UidsExporter()
    if options.list:
        print 'Shards:'
        print format_dict_table(exporter.shards_rs_hosts, ('_id', 'host'))
        sys.exit(0)

    if not rs_names:
        parser.print_help()
        sys.exit(0)

    for rs_name in rs_names:
        for uid in exporter.get_uids_from_rs(rs_name, export_sharded=bool(options.export_sharded)):
            print uid
