import argparse
import json

from mpfs.engine.process import setup_anyone_script, dbctl
from mpfs.metastorage.mongo.util import decompress_data

setup_anyone_script()

parser = argparse.ArgumentParser(description="Decompress zdata.")
parser.add_argument('-u', '--uid', required=True, dest='uid', action='store',
                    help='UID')
parser.add_argument('-p', '--path', required=True, dest='path', action='store',
                    help='Path.')

area_collection_map = {
    'disk': 'user_data',
    'trash': 'trash',
    'hidden': 'hidden_data',
    'attach': 'attach_data',
    'narod': 'narod_data',
}

if __name__ == '__main__':
    args = parser.parse_args()
    collection_name = area_collection_map[args.path.strip('/').split('/')[0]]

    collection = dbctl().database()[collection_name]
    docs = collection.find({'uid': args.uid, 'key': args.path})
    doc = docs[0]
    if 'zdata' in doc:
        doc['zdata'] = decompress_data(doc['zdata'])
    print json.dumps(doc, indent=4)
