#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
Скрипт сбора дневной аналитики
https://jira.yandex-team.ru/browse/CHEMODAN-14192
"""
import multiprocessing
import optparse
import traceback
import time

import mpfs.engine.process
from mpfs.common.util import logger
from mpfs.common.util.logger import suppress_mongo_requests_log, suppress_default_log
from mpfs.common.util import iterdbuids

import mpfs.engine.process
mpfs.engine.process.setup_admin_script()

log = mpfs.engine.process.get_default_log()
debug = mpfs.engine.process.get_error_log()


from mpfs.common import errors
from mpfs.core.user import base as user_module
from mpfs.analytics.daily import UserDailyReportBuilder
from mpfs.metastorage.mongo.collections.base import UserIndexCollection


out = logger.get('analytics-daily-personal')
empty_disk_info_log = logger.get('empty-disk-info')
user_index_collection = UserIndexCollection()


def wrapper(log_empty_disk_info=False):
    def build_report(uid):
        user_index = user_index_collection.find_one({'_id': uid})
        if user_index is None:
            log.info('User is not initialized: uid=%s' % uid)
            return None

        is_attach_user = 'type' in user_index and user_index['type'] == 'attach'
        if is_attach_user:
            log.info('Filter attach user: uid=%s' % uid)
            return None

        mpfs.engine.process.reset_cached()
        rb = UserDailyReportBuilder()
        try:
            user_module.User(uid)
        except errors.StorageEmptyDiskInfo, e:
            if log_empty_disk_info:
                empty_disk_info_log.info('%s' % uid)
            log.info(traceback.format_exc())
            return None
        result = rb.get_report(uid)
        result['puid'] = uid
        return result
    return build_report



t = time.strftime('%Y-%m-%d 00:00:00', time.localtime())
PREFIX = "tskv\ttskv_format=ydisk-usage-log\ttimestamp=%s\ttimezone=+0400\t" % t

def write_result(result):
    if result:
        final_string = PREFIX + '\t'.join(map(lambda (k, v): '%s=%s' % (k, v), result.iteritems()))
        out.info(final_string)


option_list = (
    optparse.Option('-f', '--file',
                    type='string', action='store',
                    dest='file', default='/tmp/mpfs-daily-uids-cache.txt',
                    help='File where to store local uid cache. Default is "%default".'),
    optparse.Option('-p', '--processes',
                    type='int', action='store',
                    dest='processes', default=None,
                    help='Number of processes. Default is your CPU count: %d.' % multiprocessing.cpu_count()),
    optparse.Option('-s', '--silent',
                    action='store_true',
                    dest='silent', default=False,
                    help='Disable service-warehouse.log'),
    optparse.Option('-i', '--disk-info',
                    action='store_true',
                    dest='disk_info', default=False,
                    help='Write UIDs with empty disk-info to stat-empty-disk-info.log'),
    optparse.Option('-t', '--termination-timeout',
                    type='int', action='store',
                    dest='termination_timeout', default=None,
                    help='How much seconds script must wait before killing subprocesses when all work is done. '
                         'If not specified, then timeout is infinite.'),
)


if __name__ == "__main__":
    parser = optparse.OptionParser(option_list=option_list)
    (options, args) = parser.parse_args()

    build_report = wrapper(log_empty_disk_info=options.disk_info)

    if options.silent:
        build_report = suppress_default_log(
            suppress_mongo_requests_log(build_report))
        iterdbuids.run = suppress_default_log(
            suppress_mongo_requests_log(iterdbuids.run))

    iterdbuids.run(build_report, write_result, options.file, max_processes=options.processes, log=debug,
                   termination_timeout=options.termination_timeout)
