#!/usr/bin/python
# -*- coding: utf-8 -*-
"""

Высылаем письмо раз в сутки всем, у кого меньше 5% процентов места на Диске,
но не чаще одного письма одному пользователю раз в семь дней.

https://jira.yandex-team.ru/browse/CHEMODAN-5888
https://jira.yandex-team.ru/browse/CHEMODAN-7194

"""
import mpfs.engine.process
mpfs.engine.process.setup_admin_script()
mpfs.engine.process.reset_cached()

import datetime
import time
import traceback

from mpfs.common.util import mailer
from mpfs.metastorage.mongo import db
from mpfs.core.services.passport_service import Passport
from mpfs.core.user.base import User

log = mpfs.engine.process.get_default_log()
passport = Passport()


def main():
    # Получаем первичные даты
    bound_stamp = int(time.time()) - 14*24*3600
    bound_date  = datetime.date.fromtimestamp(bound_stamp)
    log.info('Date: %s (%s)' % (bound_date, bound_stamp))

    # Выбираем юзеров
    for user in db.user_index.find({'type': 'standart'}, {'fields': ['_id']}):
        uid = user.get('_id')
        user_obj = User(uid)

        cron_states   = user_obj.states.list('cron')
        info = user_obj.info()

        quota = info['space']
        used, limit = quota['used'], quota['limit']

        # Пропускаем тех, у кого с пространством все ок
        percent_left = 100-100*used/limit

        if percent_left > 10:
            continue

        #если свободно больше гигабайта, пропускаем пользователя
        if quota['free'] > 1024 ** 3:
            continue

        #если свободно меньше мегабайта
        if quota['free'] < 1024 ** 2:
            #выбрать шаблон "место закончилось совсем"
            template = 'space/finished'
        else:
            #выбрать шаблон "место заканчивается"
            template = 'space/fastFinished'

        log.info('--- %s (left: %s percent) ---' % (uid, percent_left))

        # Пропускаем тех, кто был обработан менее 14 дней назад
        notified = cron_states.get('diskisfullnotify')
        if notified and notified > bound_stamp:
            log.info('skip: script check time condition')
            continue

        # Собираем данные
        try:
            user_info = passport.userinfo(uid)
        except Exception:
            log.info('skip: passport bad info')
            continue

        if not user_info['email']:
            log.info('skip: email condition')
            continue

        params = {
            'username'         : user_info['username'],
            'login'            : user_info['login'],
            'locale'           : user_info['language'],
            'space'            : quota,
        }

        # Высылаем письмо и ставим дату проверки
        try:
            mailer.send(user_info['email'], template, params)
        except Exception:
            log.error('sending email failed %s' % uid)
            log.error(traceback.format_exc())
        else:
            user_obj.states.set('diskisfullnotify', int(time.time()), 'cron')


if __name__ == "__main__":
    main()
