#!/usr/bin/python
# -*- coding: utf-8 -*-
"""

Скрипт, получающий на вход секцию из global_settings.yaml и формирующий на выход список переменных из этой секции.
Нужно для использования настроек из global_settings.yaml в upstart скриптах.

"""
import sys
from optparse import OptionParser, Option

from mpfs.config import settings

usage = "usage: %prog -h"

option_list = (
    Option(
        '-s', '--section',
        action='store',
        dest='section',
        type='string',
        help='colon-separated values from global_settings.yaml, e.g. platform:video:value1 will be translated to platform_video_value1'
    ),
)

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()


def parse_section(value):
    return value.split(':')


def get_section(value):
    chunks = parse_section(value)
    section = getattr(settings, chunks[0])
    for i in chunks[1:]:
        section = section[i]
    return section


if __name__ == "__main__":
    if options.section:
        section = get_section(options.section)
        if not isinstance(section, (int, basestring, float)):
            print 'Value is not simple type: int, string, float.'
            sys.exit(2)
        print section
    else:
        parser.print_help()
        sys.exit(2)
