#!/usr/bin/python
# -*- coding: utf-8 -*-
"""

MPFS
UWSGI Common APP

"""

import os

# import hotshot
import flask.wrappers

from flask import Flask
from flask import request
from flask import make_response
from werkzeug.datastructures import OrderedMultiDict

import mpfs.engine.process

from mpfs.engine.process import (
    set_register_after_fork_impl,
    setup_tvm_2_0_clients,
    setup_authorization_networks,
    setup_handlers_groups,
)
from mpfs.config import settings
from mpfs.common.util import logger


LOGGER_MONITOR_ENABLED = settings.logger['monitor']['enabled']
QUEUE2_PUT_TASKS_IN_NEW_QUEUE = settings.queue2['put_tasks_in_new_queue']
QUEUE2_MPFS_AUTORECONNECTOR_ENABLE = settings.queue2['mpfs']['autoreconnector']['enable']
SERVICES_TVM_2_0_ENABLED = settings.services['tvm_2_0']['enabled']


set_register_after_fork_impl(mpfs.engine.process.uwsgi_after_fork)
logger.configure_logging(settings.logger['dict_config'],
                         os.environ['MPFS_PACKAGE'])

from mpfs.core.zookeeper.shortcuts import prepare_zookeeper_settings
prepare_zookeeper_settings()
mpfs.engine.process.setup()


from mpfs.common.util.ordereddict import OrderedDict
from mpfs.core.office.util import setup_discovery
from mpfs.frontend.api.disk import billing, DiskApi, desktop, json, mail, photoslice, service
from mpfs.frontend.api import browser, invite_api, support_api
from mpfs.core.services.hbf_service import setup_hbf_cache_update


mpfs.engine.process.pre_fork()
# TODO
# Когда отпилим Браузер убрать эту проверку.
if os.environ['MPFS_PACKAGE'] == 'disk':
    setup_discovery()

flask.wrappers.Request.parameter_storage_class = OrderedMultiDict


class MpfsResponse(object):

    def __init__(self):
        self.headers = {}
        self.status = 200


class Side(object):
    apis = {
        'billing': billing.Billing(),
        'browser': browser.Browser(),
        'default': DiskApi(),
        'desktop': desktop.Desktop(),
        'invite': invite_api.Invite(),
        'json': json.JSON(),
        'mail': mail.Mail(),
        'photoslice': photoslice.Photoslice(),
        'service': service.Service(),
        'support': support_api.Support(),
    }

    def handler(self, front_client, method):
        api_obj = self.apis.get(front_client)
        resp = MpfsResponse()

        request.requestLine = request.environ.get('REQUEST_URI')
        #=======================================================================
        # GET
        if front_client == 'browser':
            params = OrderedDict()
        else:
            params = {}

        params.update(request.args.to_dict())
        # POST
        params.update(request.form.to_dict())
        #=======================================================================
        params['_request'] = request
        params['_response'] = resp

        api_obj.setup(params)

        # prfile = hotshot.Profile('/var/log/mpfs/hotshot_%s.log' % mpfs.engine.process.get_req_id())
        # prfile.start()
        response = make_response(api_obj.process(method) or '', resp.status, resp.headers)
        # prfile.stop()

        return response


if QUEUE2_PUT_TASKS_IN_NEW_QUEUE and QUEUE2_MPFS_AUTORECONNECTOR_ENABLE:
    from mpfs.engine.queue2.utils import setup_brokers_reconnect_timer
    setup_brokers_reconnect_timer()


setup_authorization_networks()
setup_handlers_groups()

if SERVICES_TVM_2_0_ENABLED:
    from mpfs.core.services.tvm_2_0_service import tvm2
    setup_tvm_2_0_clients(settings.auth['clients'])
    tvm2.update_public_keys(silent_mode_on_errors=False)
    tvm2.update_service_tickets()

setup_hbf_cache_update()

s = Side()
# Чтобы мастер процесс не держал лог файлы открытыми.
logger.close_log_handlers()
# Чтобы запустить тред монитор логов после форка
if LOGGER_MONITOR_ENABLED:
    logger.enable_monitor()

# не удалять, импортируются хуки для uwsgi
if settings.zookeeper['isolate_zk']:
    print '[zk settings] isolation from zookeeper: true'
else:
    print '[zk settings] isolation from zookeeper: false'
    print '[zk settings] apply_new_settings: %s' % settings.zookeeper['apply_new_settings']
    from mpfs.core.zookeeper.uwsgi_hooks import preload_settings_and_start_zk_init  # noqa

from mpfs.core.zookeeper.cache_writer import update_settings_cache_file
update_settings_cache_file.spool()

application = Flask(__name__)

@application.route('/', defaults={'path': ''})
@application.route('/<path:path>', methods=['GET', 'POST'])
def default(path):
    h_type = 'default'
    try:
        h_type, _path = path.rstrip('/').split('/')
    except ValueError:
        _path = path
    return s.handler(h_type, _path)


if __name__ == '__main__':
    from optparse import OptionParser
    parser = OptionParser()
    parser.add_option('-H', '--host', type='string', dest='host', default='0.0.0.0', metavar='HOST', help='host')
    parser.add_option('-p', '--port', type='int', dest='port', default='4131', metavar='PORT', help='port')
    (options, args) = parser.parse_args()
    application.debug = True
    application.run(host=options.host, port=options.port)
