# -*- coding: utf-8 -*-
import os
import sys
from glob import glob

from setuptools import find_packages, setup

sys.path.insert(0, os.path.abspath(os.path.join('.', 'tools')))
from build_common import collect_data_files, get_packages_with_data, build_data_files, get_package_name_from_deb_control


# Common part

mpfs_package_dir = 'lib/mpfs'
packages_with_data = get_packages_with_data(mpfs_package_dir)
PACKAGES = packages_with_data.keys()
PACKAGE_DATA = {k: v for (k, v) in packages_with_data.iteritems() if v}


SCRIPTS = []
for filename in os.listdir('apps/common'):
    if filename.endswith('.py'):
        SCRIPTS.append('apps/common/%s' % filename)

DATA_FILES = []
DATA_FILES.extend(build_data_files('/etc/yandex/mpfs', 'apps/common/conf/mpfs'))

DATA_FILES.extend(build_data_files('/etc/yandex/mpfs/keys', 'apps/common/keys'))
DATA_FILES.extend(build_data_files('/usr/sbin/', 'apps/common/scripts/admin', flat=True))
DATA_FILES.extend(build_data_files('/usr/sbin/', 'apps/common/scripts/utils', flat=True))
DATA_FILES.extend(build_data_files('/usr/sbin/', 'apps/common/scripts/cron'))
DATA_FILES.extend(build_data_files('/etc/bash_completion.d/', 'apps/common/scripts/bash_completion'))

ENTRY_POINTS = {'console_scripts': ['mpfs-cli = mpfs.cli:main']}

# Package related part
package = get_package_name_from_deb_control('debian/control')
if package is None:
    sys.stderr.write('No debian/control is found in mpfs folder (should be automatically copied from package folder)')
    sys.exit(2)

package_folder = None
if package == 'python-mpfs-disk':
    package_folder = 'disk'

    DATA_FILES.extend([
        ('/etc/yandex/mpfs/overrides', glob('apps/disk/conf/mpfs/overrides/*')),
        ('/etc/yandex/mpfs', ['apps/disk/conf/package.type']),

        ('/etc/yandex/mpfs/uwsgi', glob('apps/disk/conf/uwsgi/uwsgi-disk.conf.*')),
        ('/etc/init/', glob('apps/disk/conf/uwsgi/*.conf')),

        ('/etc/logrotate.d/', [
            'apps/disk/conf/logrotate/logrotate-mpfs-disk',
        ]),

        ('/etc/mpfs/cron-task-configs', [
            'apps/disk/conf/bazinga/mpfs_stat_tasks.json',
            'apps/disk/conf/bazinga/mpfs_deleted_stids_day_merge_sort.json',
            'apps/disk/conf/bazinga/mpfs_deleted_stids_create_tasks_from_yt.json',
            'apps/disk/conf/bazinga/mpfs_storage_cleaner_manager.json',
            'apps/disk/conf/bazinga/mpfs_hidden_data_cleaner_manager.json',
            'apps/disk/conf/bazinga/mpfs_billing_errors.json',
            'apps/disk/conf/bazinga/mpfs_billing_process.json',
            'apps/disk/conf/bazinga/mpfs_billing_notify.json',
            'apps/disk/conf/bazinga/mpfs_billing_orders.json',
            'apps/disk/conf/bazinga/mpfs_resync_yateam_users.json',
            'apps/disk/conf/bazinga/mpfs_resync_organizations.json',
            'apps/disk/conf/bazinga/mpfs_postgres_clean_hanging_storage_duplicates.json',
            'apps/disk/conf/bazinga/mpfs_postgres_delete_expired_entries.json',
            'apps/disk/conf/bazinga/mpfs_storage_cleaner_retry_remove.json',
            'apps/disk/conf/bazinga/mpfs_versioning_remove_expired_versions.json',
            'apps/disk/conf/bazinga/mpfs_user_activity_info_load_from_yt.json',
            'apps/disk/conf/bazinga/mpfs_quick_move_link_data_update_manager.json',
            'apps/disk/conf/bazinga/mpfs_quick_move_reindex_manager.json',
            'apps/disk/conf/bazinga/mpfs_frozen_operations_monitoring.json',
            'apps/disk/conf/bazinga/mpfs_create_overdraft_send_message_tasks.json',
            'apps/disk/conf/bazinga/mpfs_create_overdraft_cleaner_tasks.json',
            'apps/disk/conf/bazinga/mpfs_inactive_users_flow_manager.json',
            'apps/disk/conf/bazinga/mpfs_remove_expired_links.json',
        ]),
        ('/etc/mpfs/onetime-tasks-config', [
            'apps/disk/conf/bazinga/mpfs_storage_cleaner_worker.json',
            'apps/disk/conf/bazinga/mpfs_quick_move_link_data_update_worker.json',
            'apps/disk/conf/bazinga/mpfs_quick_move_reindex_worker.json',
            'apps/disk/conf/bazinga/mpfs_overdraft_cleaner_worker.json',
            'apps/disk/conf/bazinga/mpfs_overdraft_send_message_worker.json',
        ]),
    ])
elif package == 'python-mpfs-api':
    package_folder = 'api'

    DATA_FILES.extend([
        ('/etc/yandex/mpfs/overrides', glob('apps/api/conf/mpfs/overrides/*')),
        ('/etc/yandex/mpfs', ['apps/api/conf/package.type']),

        ('/etc/yandex/mpfs/uwsgi', glob('apps/api/conf/uwsgi/*.conf.*')),
        ('/etc/init/', glob('apps/api/conf/uwsgi/*.conf')),

        ('/etc/logrotate.d/', [
            'apps/api/conf/logrotate/logrotate-mpfs-api',
        ]),
    ])

    # файлы админки
    # *.py
    PACKAGES.extend(find_packages(where='lib', exclude=('mpfs', 'mpfs.*')))
    # *.settings.py
    DATA_FILES.extend(build_data_files('/etc/yandex/mpfs-api-admin/conf/app', 'apps/api/conf/admin'))
    # *uwsgi*.conf
    DATA_FILES.append(('/etc/yandex/mpfs-api-admin/conf/uwsgi', glob('apps/api/conf/uwsgi/*api-admin.conf*')))
    DATA_FILES.append(('/etc/init/', ['apps/api/conf/uwsgi/mpfs-api-admin-uwsgi.conf']))
    # шаблоны .html
    DATA_FILES.extend([
        (
            os.path.dirname(os.path.join('/usr/share/pyshared/api_admin', p)),
            [os.path.join('lib/api_admin', p)]
        ) for p in collect_data_files('lib/api_admin', extensions=('.html',))
    ])
    # статика
    settings_path = os.path.abspath(os.path.join('.', 'apps', 'api', 'conf', 'admin'))
    overrides_settings_path = os.path.abspath(os.path.join('.', 'apps', 'api', 'conf', 'admin', 'overrides'))
    lib_path = os.path.abspath(os.path.join('.', 'lib'))
    mpfs_config_path = os.path.abspath(os.path.join('.', 'apps', 'common', 'conf', 'mpfs'))
    os.system(
        'PYTHONPATH=$PYTHONPATH:%s:%s:%s MPFS_CONFIG_PATH=%s '
        'python apps/api/manage.py collectstatic --no-input --settings=build_settings' % (
            settings_path, overrides_settings_path, lib_path, mpfs_config_path
        )
    )
    DATA_FILES.extend(build_data_files('/usr/share/pyshared/api_admin/collected_static', 'lib/api_admin/collected_static'))
    DATA_FILES.extend(build_data_files('/usr/share/pyshared/api_admin/static', 'lib/api_admin/static'))


elif package == 'python-mpfs-browser':
    package_folder = 'browser'

    DATA_FILES.extend([
        ('/etc/yandex/mpfs/overrides', glob('apps/browser/conf/mpfs/overrides/*')),

        ('/etc/yandex/mpfs/uwsgi', glob('apps/browser/conf/uwsgi/uwsgi-browser.conf.*')),
        ('/etc/init/', glob('apps/browser/conf/uwsgi/*.conf')),

        ('/etc/yandex/mpfs', ['apps/browser/conf/package.type']),

        ('/etc/logrotate.d/', [
            'apps/browser/conf/logrotate/logrotate-mpfs-browser',
        ]),
    ])
elif package == 'python-mpfs-queue':
    package_folder = 'queue'

    DATA_FILES.extend(build_data_files('/etc/yandex/mpfs/queue/', 'apps/queue/conf/celery'))

    DATA_FILES.extend([
        ('/etc/yandex/mpfs/overrides', glob('apps/disk/conf/mpfs/overrides/*')),
        ('/etc/yandex/mpfs', ['apps/disk/conf/package.type']),

        ('/etc/init/', glob('apps/queue/conf/upstart/*.conf')),

        ('/etc/logrotate.d/', [
            'apps/queue/conf/logrotate/logrotate-mpfs-queue',
        ]),
    ])
else:
    sys.stderr.write('No such package (%s) found.' % package)
    sys.exit(2)

if package_folder:
    for filename in os.listdir('apps/%s' % package_folder):
        if filename.endswith('.py'):
            SCRIPTS.append('apps/%s/%s' % (package_folder, filename))

if __name__ == '__main__':
    setup(
        name=package,
        version='0.1',
        description='Yandex.Disk MPFS Disk',
        author='Mikhail Belov',
        author_email='dedm@yandex-team.ru',
        package_dir={
            'mpfs': mpfs_package_dir,
            'api_admin': 'lib/api_admin'
        },
        url='http://wiki.yandex-team.ru/disk',
        packages=PACKAGES,
        scripts=SCRIPTS,
        data_files=DATA_FILES,
        package_data=PACKAGE_DATA,
        entry_points=ENTRY_POINTS
    )
