# -*- coding: utf-8 -*-

from django.core.exceptions import ValidationError
from django.db import models

from mpfs.common.util import from_json, to_json


class JSONField(models.TextField):

    def from_db_value(self, value, expression, connection, context):
        if value is None:
            return value
        return from_json(value)

    def to_python(self, value):
        if isinstance(value, (dict, list)):
            return value
        if value is None:
            return value

        value = super(JSONField, self).to_python(value)
        try:
            value = from_json(value)
        except Exception:

            raise ValidationError('Couldn\'t parse JSON')
        return value

    def get_prep_value(self, value):
        value = super(JSONField, self).get_prep_value(value)
        value = to_json(value)
        return value
