# -*- coding: utf-8 -*-

import sys

from django.conf import settings
from django.core.management.base import BaseCommand
from api_admin.zookeeper import create_client

MB = 2**20


class Command(BaseCommand):
    help = 'Loads platform auth settings to Zookeeper.'

    def handle(self, *args, **options):
        from mpfs.common.util import to_json
        from mpfs.config import settings as mpfs_settings

        client = create_client()
        data = mpfs_settings.platform['auth']
        client.set(
            settings.ZOOKEEPER_PLATFORM_AUTH_SETTINGS_PATH,
            to_json(data).encode('utf8')
        )

        value, stats = client.get(settings.ZOOKEEPER_PLATFORM_AUTH_SETTINGS_PATH)
        print value
        size = sys.getsizeof(value)
        print 'Bytes:', size
        if size > 0.9 * MB:
            print 'Warning! Size is close to max size of Znode.'
        print 'Done.'
