# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from django.db import migrations


SCOPES = [
    'cloud_api.data:app_data',
    'cloud_api.data:set_revision',
    'cloud_api.data:user_data',
    'cloud_api.profile:generic.market.delivery_addresses.read',
    'cloud_api.profile:generic.market.delivery_addresses.write',
    'cloud_api.profile:generic.videosearch.likes.read',
    'cloud_api.profile:generic.videosearch.likes.write',
    'cloud_api.profile:generic.yanews.rubrics.read',
    'cloud_api.profile:generic.yanews.rubrics.write',
    'cloud_api.profile:generic.yanews.search.read',
    'cloud_api.profile:generic.yanews.search.write',
    'cloud_api.profile:generic.yanews.smi.read',
    'cloud_api.profile:generic.yanews.smi.write',
    'cloud_api:data.app_data',
    'cloud_api:data.user_data',
    'cloud_api:disk.app_folder',
    'cloud_api:disk.info',
    'cloud_api:disk.read',
    'cloud_api:disk.write',
    'yadisk:all'
]


def forwards(apps, schema_editor):
    Scope = apps.get_model('api_auth', 'Scope')
    for key in SCOPES:
        Scope.objects.create(key=key)


def backwards(apps, schema_editor):
    Scope = apps.get_model('api_auth', 'Scope')
    for key in SCOPES:
        Scope.objects.delete(key=key)


class Migration(migrations.Migration):

    dependencies = [
        ('api_auth', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(code=forwards, reverse_code=backwards)
    ]
