# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import datetime

from django.db import models

from api_admin.api_auth.db_fields import JSONField
from api_admin.site_auth.models import User
from mpfs.core.zookeeper.shortcuts import get_checksum


class Scope(models.Model):
    key = models.CharField(max_length=128, null=False, verbose_name='Ключ', primary_key=True)
    description = models.CharField(max_length=256, null=True, blank=True, verbose_name='Описание')
    notes = models.CharField(max_length=512, null=True, blank=True, verbose_name='Заметки')

    class Meta:
        verbose_name = 'Скоуп'
        verbose_name_plural = 'Скоупы'

    def __unicode__(self):
        return self.key


class AuthRulesBackup(models.Model):
    data = JSONField(null=False, verbose_name='Дамп конфига')
    ctime = models.DateTimeField(null=False, verbose_name='Время создания дампа')
    checksum = models.CharField(max_length=128, null=False, blank=False, verbose_name='Чек сумма')
    user = models.ForeignKey(User, null=False, blank=True, verbose_name='Создатель дампа', on_delete=models.PROTECT)

    @staticmethod
    def create_backup(user, data):
        AuthRulesBackup.objects.create(data=data, ctime=datetime.datetime.now(), user=user, checksum=get_checksum(data))
