# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging
import posixpath

from api_admin.signals import pre_config_changes, zk_client_created
from django.conf import settings
from django.dispatch import receiver


logger = logging.getLogger('mpfs-api-admin.default')


@receiver(zk_client_created)
def ensure_auth_path(sender, **kwargs):
    zk = kwargs['zk']
    zk.ensure_path(settings.ZOOKEEPER_PLATFORM_AUTH_SETTINGS_PATH)
    message = 'Ensured "%s" path on ZK' % posixpath.join(zk.chroot, settings.ZOOKEEPER_PLATFORM_AUTH_SETTINGS_PATH)
    try:
        import uwsgi
    except ImportError:
        message = '%s.' % message
    else:
        message = '%s (worker %s got signal).' % (message, uwsgi.worker_id())

    logger.info(message)


@receiver(pre_config_changes)
def create_backup(sender, **kwargs):
    from api_admin.api_auth.models import AuthRulesBackup  # не выносить отсюда, так как ломает django.setup()

    user = kwargs['user']
    data = kwargs['config_dict']
    AuthRulesBackup.create_backup(user, data)
