# -*- coding: utf-8 -*-

from django.conf.urls import url

import views

app_name = 'api_auth'
urlpatterns = [
    url(r'^clients$', views.AuthClientListView.as_view(), name='client-list'),
    url(r'^clients/add', views.AuthClientAddView.as_view(), name='client-add'),
    url(r'^clients/(?P<id>.+)/edit$', views.AuthClientEditView.as_view(), name='client-detail-edit'),
    url(r'^clients/(?P<id>.+)$', views.AuthClientDetailView.as_view(), name='client-detail'),
    url(r'^auth-backups$', views.AuthRulesBackupListView.as_view(), name='auth-backup-list'),
    url(r'^auth-backups/(?P<checksum>.+)$', views.AuthRulesBackupDetailView.as_view(), name='auth-backup-details'),
    url(r'^config/upload$', views.AuthRulesUploadView.as_view(), name='config-upload'),
]
