# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand

from kazoo.exceptions import NodeExistsError


class Command(BaseCommand):
    help = 'List all workers with their settings states.'

    def handle(self, *args, **options):
        from mpfs.common.util import from_json

        from api_admin.zookeeper import get_or_create_client
        from mpfs.core.zookeeper.shortcuts import get_checksum

        zk_client = get_or_create_client()
        workers_reported_latest = zk_client.get_children(settings.ZOOKEEPER_WORKER_STATE_LATEST_CONFIG_BASE_PATH)
        workers_reported_applied = zk_client.get_children(settings.ZOOKEEPER_WORKER_STATE_APPLIED_CONFIG_BASE_PATH)

        workers_set = set(workers_reported_latest + workers_reported_applied)

        states = {}
        for worker in workers_set:
            states[worker] = {
                'latest': None,
                'applied': None
            }
            try:
                data, stats = zk_client.get('%s/%s' % (settings.ZOOKEEPER_WORKER_STATE_LATEST_CONFIG_BASE_PATH, worker))
                data = from_json(data)
                checksum = get_checksum(data)
                states[worker]['latest'] = checksum
            except NodeExistsError:
                pass

            try:
                data, stats = zk_client.get('%s/%s' % (settings.ZOOKEEPER_WORKER_STATE_APPLIED_CONFIG_BASE_PATH, worker))
                data = from_json(data)
                checksum = get_checksum(data)
                states[worker]['applied'] = checksum
            except NodeExistsError:
                pass

        zk_client.stop()
        for worker in sorted(states):
            print worker, 'latest:%s' % states[worker]['latest'], 'applied:%s' % states[worker]['applied']

        print 'Done.'


