# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations

PRODUCTION_DOMAIN = 'disk-admin.yandex-team.ru'


def forwards(apps, schema_editor):
    Site = apps.get_model('sites', 'Site')
    Site.objects.create(domain=PRODUCTION_DOMAIN)


def backwards(apps, schema_editor):
    Site = apps.get_model('sites', 'Site')
    Site.objects.delete(domain=PRODUCTION_DOMAIN)


class Migration(migrations.Migration):

    dependencies = [
        ('sites', '0001_initial')
    ]

    operations = [
        migrations.RunPython(code=forwards, reverse_code=backwards)
    ]
