# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from django.core.urlresolvers import reverse


def menu(request):
    # FIXME: это лишь заготовка для нормального динамического меню
    # TODO: Нужна поддержка отслеживания активного элемента меню и раскрытие только его родителей
    # TODO: на основе URL в объекте запроса.
    return {
        'menu': [
            {
                'name': 'Клиенты',
                'url': '#',
                'icon': 'fa-user-secret',
                'items': [
                    {
                        'name': 'Добавить',
                        'url': reverse('api_auth:client-add'),
                        'icon': 'fa-user-plus',
                        'items': []
                    },
                    {
                        'name': 'Список',
                        'url': '#',
                        'icon': 'fa-users',
                        'items': [
                            {
                                'name': 'Таблица',
                                'url': reverse('api_auth:client-list') + '?view=table',
                                'icon': 'fa-table',
                                'items': []
                            },
                            {
                                'name': 'JSON',
                                'url': reverse('api_auth:client-list') + '?view=json',
                                'icon': 'fa-code',
                                'items': []
                            }
                        ]
                    },
                    {
                        'name': 'Бэкапы',
                        'url': reverse('api_auth:auth-backup-list'),
                        'icon': 'fa-database',
                        'items': []
                    },
                    {
                        'name': 'Загрузить конфиг',
                        'url': reverse('api_auth:config-upload'),
                        'icon': 'fa-cloud-upload',
                        'items': []
                    },
                ]
            }
        ]
    }
