# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import itertools
import os
import socket

__all__ = [
    'get_app_name',
    'get_host_name',
    'get_yandex_cloud_request_id',
    'set_yandex_cloud_request_id',
    'get_uid',
    'set_uid'
]

app_name = 'mpfs-api-admin'
host_name = socket.gethostname()
request_id = None
yandex_cloud_request_id = None
uid = None


def get_app_name():
    return app_name


def get_host_name():
    return host_name


def get_request_id():
    return request_id


def set_request_id(value):
    global request_id
    request_id = value


def get_yandex_cloud_request_id():
    return yandex_cloud_request_id


def set_yandex_cloud_request_id(value):
    global yandex_cloud_request_id
    yandex_cloud_request_id = value


def get_uid():
    return uid


def set_uid(value):
    global uid
    uid = value


cycle_100000 = itertools.cycle(xrange(100000))


def generate_request_id():
    return '%s_%s' % (os.getpid(), cycle_100000.next())
