# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.exceptions import PermissionDenied
from django.http import HttpResponseRedirect

from django_yauth.util import (get_current_url, get_passport_url, get_yauth_type)

from api_admin.site_auth import roles


def user_is_member_of_any_group(user, group_names):
    return user.groups.filter(name__in=group_names).exists()


def has_any_role(user, role_names):
    role_names = set(role_names)
    if roles.ROLE_NAME_SUPERUSER in role_names:
        if user.is_superuser:
            return True

    role_names.remove(roles.ROLE_NAME_SUPERUSER)  # защита на случай, если заведут такую группу бездумно

    return user_is_member_of_any_group(user, role_names)


def auth_check(**kwargs):
    def outer(func):
        def inner(request, *func_args, **func_kwargs):
            if request.yauser.is_authenticated():
                role_names = kwargs.get('role_names', [])
                user = request.user

                if has_any_role(user, role_names):
                    return func(request, *func_args, **func_kwargs)

                raise PermissionDenied()
            else:
                return_path = get_current_url(request, add_params={settings.YAUTH_ANTI_REPEAT_PARAM: 1})
                passport_url = get_passport_url('create', get_yauth_type(request), request=request, retpath=return_path)
                return HttpResponseRedirect(passport_url)
        return inner
    return outer
