# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from django.db import migrations


IDM_ROLE_NAME_EDITOR = 'редактор'
IDM_ROLE_NAME_VIEWER = 'просмотрщик'


def forwards(apps, schema_editor):
    Group = apps.get_model('auth', 'Group')
    Group.objects.create(name=IDM_ROLE_NAME_EDITOR)
    Group.objects.create(name=IDM_ROLE_NAME_VIEWER)


def backwards(apps, schema_editor):
    Group = apps.get_model('auth', 'Group')
    Group.objects.delete(name=IDM_ROLE_NAME_EDITOR)
    Group.objects.delete(name=IDM_ROLE_NAME_VIEWER)


class Migration(migrations.Migration):

    dependencies = [
        ('site_auth', '0002_user_email'),
    ]

    operations = [
        migrations.RunPython(code=forwards, reverse_code=backwards)
    ]
