# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from django.contrib.auth.models import PermissionsMixin
from django.db import models
from django.utils.encoding import python_2_unicode_compatible


@python_2_unicode_compatible
class User(PermissionsMixin):
    username = models.CharField(verbose_name='Логин', max_length=30, unique=True)
    is_staff = models.BooleanField(verbose_name='Сотрудник', default=False)
    email = models.EmailField(verbose_name='E-mail', null=True)

    USERNAME_FIELD = 'username'
    REQUIRED_FIELDS = []

    class Meta:
        verbose_name = 'Пользователь'
        verbose_name_plural = 'Пользователи'

    def get_full_name(self):
        return self.username

    def get_short_name(self):
        return self.username

    def get_username(self):
        return getattr(self, self.USERNAME_FIELD)

    def __str__(self):
        return self.get_username()

    def natural_key(self):
        return self.get_username(),

    @property
    def is_active(self):
        return True

    def is_anonymous(self):
        return False

    def is_authenticated(self):
        return True

    def set_unusable_password(self):
        pass

