# -*- coding: utf-8 -*-

import json

from pygments import highlight
from pygments.lexers import JsonLexer
from pygments.formatters import HtmlFormatter

from django import template
from django.utils.safestring import mark_safe

register = template.Library()


@register.filter
def get_type(value):
    return type(value).__name__


@register.filter
def has_key(value, arg):
    return arg in value


@register.filter
def get_key(value, arg):
    return value[arg]


@register.filter(name='jsonify2')
def jsonify2(value):
    formatter = HtmlFormatter(style='colorful')
    lexer = JsonLexer()
    response = json.dumps(value, sort_keys=True, indent=2)
    response = highlight(response, lexer, formatter)
    style = '<style>' + formatter.get_style_defs() + '</style><br>'
    return mark_safe(style + response)
