# -*- coding: utf-8 -*-

from functools import partial

from django.conf import settings
from django.conf.urls import include, url
from django.contrib.staticfiles.urls import staticfiles_urlpatterns
from django.views import defaults

from api_admin.admin import site as admin_site
from api_admin.views import env, index, ping, who_am_i, list_workers, get_worker_state

handler403 = partial(defaults.permission_denied, template_name='common/403.html')

urlpatterns = [
    url(r'^$', index, name='index'),
    url(r'^ping$', ping, name='ping'),
    url(r'^env$', env, name='env'),
    url(r'^who-am-i$', who_am_i, name='who_am_i'),
    url(r'^workers/$', list_workers, name='workers-list'),
    url(r'^workers/(?P<identifier>.+)$', get_worker_state, name='workers-detail'),
    url(r'^admin/', admin_site.urls),
    url(r'^idm/', include('django_idm_api.urls')),
    url(r'^api-auth/', include('api_admin.api_auth.urls')),
]


if settings.DEBUG:
    urlpatterns += staticfiles_urlpatterns()
