# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from uwsgidecorators import postfork

from api_admin.zookeeper import set_client, create_client


logger = logging.getLogger('mpfs-api-admin.default')


@postfork
def connect_zookeeper():
    import uwsgi  # не выносить
    worker_id = uwsgi.worker_id()
    logger.info('Connecting zookeeper after fork on worker %s...' % worker_id)
    set_client(create_client())
    logger.info('Default zookeeper client for worker %s has been set.' % worker_id)
