# -*- coding: utf-8 -*-
class BaseAnalyticsReportBuilder(object):
    _collector_prefix = 'collect_'
    report = {}

    def get_collectors(self):
        ret = []
        for attr_name in dir(self):
            if attr_name.startswith(self._collector_prefix):
                attr = getattr(self, attr_name)
                if hasattr(attr, '__call__'):
                    ret.append(attr)
        return ret

    def _run_collectors(self, *args, **kwargs):
        """
        Run all collectors with specified args and kwargs.
        :param args:
        :param kwargs:
        :return: Summarized result of all collectors.
        """
        collectors = self.get_collectors()
        for c in collectors:
            self.report.update(c(*args, **kwargs))

    def get_report(self, source_data):
        """
        Get report for specified args and kwargs.
        :param args:
        :param kwargs:
        :return:
        """
        self.report = {}
        args, kwargs = self.get_prepared_data(source_data)
        self._run_collectors(*args, **kwargs)
        return self.report

    def get_prepared_data(self, *args, **kwargs):
        """
        Convert source arguments to tuple of list and dict containing args and kwargs for collectors.
        :return:
        """
        return args, kwargs

    def iterreports(self, source_iterable):
        """
        Create generator creating reports for each args item.
        :param args: Iterable containing source data for collectors as pairs (list, dict).
        :return:
        """
        for source_data in source_iterable:
            yield self.get_report(source_data)
