# -*- coding: utf-8 -*-

import click
import requests

from mpfs.core.filesystem.cli import filesystem

requests.packages.urllib3.disable_warnings()

import mpfs
from mpfs.core.albums.cli import albums
from mpfs.core.filesystem.cleaner.cli import storage_cleaner
from mpfs.core.inactive_users_flow.cli import inactive_users_flow
from mpfs.core.overdraft.cli import overdraft
from mpfs.core.promo_codes.cli import promo_codes
from mpfs.core.rostelecom_unlim.cli import rostelecom_unlim
from mpfs.core.services.cli import services
from mpfs.core.public_links.cli import public_links
from mpfs.core.user.cli import user
from mpfs.metastorage.cli import metastorage
from mpfs.core.user_activity_info.cli import user_activity_info
from mpfs.core.versioning.cli import versioning
from mpfs.core.zookeeper.cli import zookeeper
from mpfs.cli.ipython import ipython


@click.group(help=u'MPFS Command Line Interface')
@click.version_option(version=mpfs.__version__, prog_name="MPFS")
def main():
    pass


commands = [
    albums,
    filesystem,
    ipython,
    metastorage,
    overdraft,
    promo_codes,
    rostelecom_unlim,
    services,
    storage_cleaner,
    inactive_users_flow,
    user,
    user_activity_info,
    versioning,
    zookeeper,
    public_links]

for command in commands:
    main.add_command(command)

if __name__ == '__main__':
    main()
