# -*- coding: utf-8 -*-
"""

MPFS
CORE

Исключения
"""

from mpfs.common.static import codes
from mpfs.common.errors.common import MPFSRootException, MPFSError, APIError
from mpfs.common.errors import billing
from mpfs.common.errors import platform
from mpfs.common.static.codes import INTERNAL_ERROR


class ControllerMPFSError(MPFSError):
    """Ошибки базового контроллера mpfs.controllers"""
    code = codes.CONTROLLER_MPFS_ERROR


class ZeroUpdateControllerMPFSError(ControllerMPFSError):
    """Ошибка update-а при отсутсвии измененных документов в БД"""


class MPFSTimeout(MPFSError):
    code = codes.MPFS_TIMEOUT

class EmptyFields(MPFSError):
    code = codes.EMPTY_FIELDS

class MPFSNotImplemented(MPFSError):
    code = codes.METHOD_NOT_IMPLEMENTED

class NotFound(MPFSError):
    pass

class TryAgain(MPFSError):
    pass


class Forbidden(MPFSError):
    code = codes.FORBIDDEN


class BadRequestError(MPFSError):
    code = codes.BAD_REQUEST_ERROR


class DecryptionError(MPFSError):
    code = codes.DECRYPTION_ERROR

class AddressError(MPFSError):
    code = codes.PATH_ERROR

class PreconditionsFailed(MPFSError):
    code = codes.PRECONDITIONS_FAILED

class StorageAddressError(AddressError):
    code = codes.STORAGE_ADDRESS_ERROR

class ListPathError(AddressError):
    code = codes.LIST_BAD_PATH

class TreePathError(AddressError):
    code = codes.TREE_BAD_PATH

class ServicesPathError(AddressError):
    code = codes.SERVICES_BAD_PATH

class InfoPathError(AddressError):
    code = codes.INFO_BAD_PATH

class UrlPathError(AddressError):
    code = codes.URL_BAD_PATH

class MkdirPathError(AddressError):
    code = codes.MKDIR_BAD_PATH


class InvalidResourcePathError(AddressError):
    code = codes.INVALID_RESOURCE_PATH


class RmPathError(AddressError):
    code = codes.RM_BAD_PATH

class QuotaPathError(AddressError):
    pass

class FactoryError(MPFSError):
    pass

class FolderError(MPFSError):
    pass

class ResourceExist(MPFSError):
    code = codes.RESOURCE_EXISTS

class NotFolder(FolderError):
    code = codes.NOT_FOLDER

class FolderTooDeep(FolderError):
    code = codes.FOLDER_TOO_DEEP

class ResourceNotFound(NotFound):
    code = codes.RESOURCE_NOT_FOUND

class OverdraftUserPublicLinkDisabled(ResourceNotFound):
    code = codes.OVERDRAFT_USER_PUBLIC_LINK_IS_DISABLED

class PublicLinkSettingsDisabled(ResourceNotFound):
    code = codes.PUBLIC_LINK_SETTINGS_IS_DISABLED

class FileNotFound(ResourceNotFound):
    code = codes.FILE_NOT_FOUND

class FolderNotFound(ResourceNotFound):
    code = codes.FOLDER_NOT_FOUND

class ParentNotFound(FolderNotFound):
    pass

class RmNotFound(ResourceNotFound):
    code = codes.RM_NOT_FOUND

class ServiceNotFound(NotFound):
    code = codes.SERVICE_NOT_FOUND

class ListNotFolder(NotFolder):
    code = codes.LIST_NOT_FOLDER

class TreeNotFolder(NotFolder):
    code = codes.TREE_NOT_FOLDER

class ServicesNotFolder(NotFolder):
    code = codes.SERVICES_NOT_FOLDER

class MkdirNotFolder(NotFolder):
    code = codes.MKDIR_NOT_FOLDER

class FolderAlreadyExist(ResourceExist):
    pass

class MkdirFolderAlreadyExist(FolderAlreadyExist):
    code = codes.MKDIR_EXISTS

class CopyError(MPFSError):
    pass

class CopyInfectedFileError(CopyError):
    code = codes.COPY_INFECTED_FILE

class CopyFromDiskError(CopyError):
    code = codes.COPY_FROM_DISK_ERROR

class CopyTargetExists(CopyError):
    code = codes.COPY_D2D_RESOURCE_EXISTS

class CopySame(CopyError):
    code = codes.COPY_SAME_RESOURCE

class MoveSame(CopyError):
    code = codes.MOVE_SAME_RESOURCE

class MoveParentToChild(CopyError):
    code = codes.MOVE_PARENT_CHILD_RESOURCE

class MoveWrongDestination(CopyError):
    code = codes.MOVE_WRONG_DESTINATION

class FileError(MPFSError):
    pass

class NotFile(FileError):
    code = codes.NOT_FILE

class MakeFileError(MPFSError):
    pass

class SetPublicNotFile(NotFile):
    code = codes.SET_PUBLIC_NOT_FILE

class StoreParentNotFound(ResourceNotFound):
    code = codes.STORE_NOT_FOUND

class StoreAlreadyExists(FileError):
    code = codes.STORE_FILE_EXISTS

class DStoreNotMatch(FileError):
    code = codes.DSTORE_FILE_NOT_MATCH

class UrlNotFile(FileError):
    code = codes.URL_NOT_FILE

class UrlNotFound(ResourceNotFound):
    code = codes.URL_NOT_FOUND

class ListNotFound(ResourceNotFound):
    code = codes.LIST_NOT_FOUND

class TreeNotFound(ResourceNotFound):
    code = codes.TREE_NOT_FOUND

class ServicesNotFound(ResourceNotFound):
    code = codes.SERVICES_NOT_FOUND

class InfoNotFound(ResourceNotFound):
    code = codes.INFO_NOT_FOUND

class MkdirNotFound(ResourceNotFound):
    code = codes.MKDIR_NOT_FOUND

class CopyNotFound(ResourceNotFound):
    code = codes.COPY_NOT_FOUND

class CopyParentNotFound(ResourceNotFound):
    code = codes.COPY_PARENT_NOT_FOUND

class MoveNotFound(ResourceNotFound):
    code = codes.MOVE_NOT_FOUND

class SetpropNotFound(ResourceNotFound):
    code = codes.SETPROP_NOT_FOUND

class SetpropStaticFields(MPFSError):
    code = codes.SETPROP_STATIC_FIELDS


class SetpropInternalFields(MPFSError):
    code = codes.SETPROP_INTERNAL_FIELDS


class DiffNotFound(ResourceNotFound):
    code = codes.DIFF_NOT_FOUND


class FileAlreadyExist(ResourceExist):
    code = codes.FILE_EXISTS


class LivePhotoUploadAttemptRegularPhotoExists(FileAlreadyExist):
    pass


class FilePresentedInDeletionLog(FileAlreadyExist):
    code = codes.FILE_PRESENTED_IN_DELETION_LOG


class ForbiddenVideoUnlim(APIError):
    code = codes.FORBIDDEN_VIDEO_UNLIM


class ForbiddenPhotoUnlim(APIError):
    code = codes.FORBIDDEN_PHOTOUNLIM


class OperationError(MPFSError):
    pass

class OperationNotFound(MPFSError):
    code = codes.OPERATION_NOT_FOUND

class OperationClassNotFound(MPFSError):
    code = codes.OPERATION_CLASS_NOT_FOUND

class OperationWrongState(MPFSError):
    pass

class DatabaseError(MPFSError):
    pass

class ZaberunError(APIError):
    pass

class ZaberunNoResponse(ZaberunError):
    code = codes.ZABERUN_NO_RESPONSE

class MulcaError(APIError):
    pass

class MulcaNoResponse(MulcaError):
    code = codes.MULCA_NO_RESPONSE


class LentaBadArgumentsUnhandledError(MPFSError):
    code = codes.LENTA_BAD_ARGUMENTS_UNHANDLED


class LentaLoaderError(APIError):
    pass


class LentaLoaderNoResponse(LentaLoaderError):
    code = codes.LENTA_LOADER_NO_RESPONSE


class ClckError(APIError):
    pass

class ClckNoResponse(ClckError):
    code = codes.CLCK_NO_RESPONSE

class KladunError(APIError):
    pass

class KladunNoResponse(KladunError):
    code = codes.KLADUN_NO_RESPONSE

class KladunStatusFailure(KladunError):
    code = codes.KLADUN_STATUS_FAILURE

class KladunOperationNotFound(OperationNotFound):
    code = codes.KLADUN_OPERATION_NOT_FOUND

class KladunHardlinkFound(KladunError):
    code = codes.KLADUN_HARDLINK_FOUND

class KladunBadResponse(KladunError):
    pass

class KladunConflict(KladunError):
    code = codes.KLADUN_CONFLICT


class EmptyFileUploadedForNonEmpyStoreError(MPFSError):
    code = codes.EMPTY_FILE_UPLOADED_FOR_NON_EMPTY_STORE


class LivePhotoNotFound(KladunError):
    code = codes.LIVE_PHOTO_NOT_FOUND

class LivePhotoMultipleFound(KladunError):
    code = codes.LIVE_PHOTO_MULTIPLE_FOUND

class KladunUnknownStage(KladunError):
    pass

class KladunAsyncCall(KladunError):
    pass

class KladunUnexpectedCallbackState(KladunError):
    code = codes.KLADUN_UNEXPECTED_CALLBACK_STATE

class KladunFileModifiedBetweenCallbacks(KladunError):
    code = codes.KLADUN_FILE_MODIFIED_BETWEEN_CALLBACKS

class OperationNotFoundError(MPFSError):
    pass

class NarodNoResponse(APIError):
    code = codes.NAROD_NO_RESPONSE

class NarodBadResponse(APIError):
    code = codes.NAROD_BAD_RESPONSE

class StorageError(APIError):
    code = codes.WH_ERROR

class MongosNotSupportedError(StorageError):
    pass

class RoutingError(StorageError):
    pass

class EmptyQueryRoutingError(RoutingError):
    pass

class NotShardedCollectionRoutingError(RoutingError):
    pass

class NotAllowedMethodRoutingError(RoutingError):
    pass

class NoShardForUidRoutingError(RoutingError):
    pass

class UidRouteAlreadyCreatedError(RoutingError):
    pass

class ShardNotAvailable(StorageError):
    code = codes.SHARD_NOT_AVAILABLE

class ResourceLocked(StorageError):
    code = codes.RESOURCE_LOCKED

class ParentResourceLocked(ResourceLocked):
    pass

class ResourceLockFailed(ResourceLocked):
    pass

class ResourceCheckLockFailed(ResourceLocked):
    pass

class StidLockedError(StorageError):
    code = codes.RESOURCE_LOCKED

class StidLockFailedError(StidLockedError):
    pass

class StorageReturnedPartialDiff(StorageError):
    code = codes.PARTIAL_DIFF

class StorageSizeNotFound(StorageError):
    code = codes.SIZE_NOT_FOUND

class StorageNoResponse(StorageError):
    code = codes.WH_NO_RESPONSE

class StorageConnectionError(StorageError):
    pass

class StorageConfigurationError(StorageError):
    pass

class StorageOperationError(StorageError):
    pass

class StorageEmptyDiskInfo(StorageError):
    code = codes.WH_RESOURCE_NOT_FOUND

class StorageInitUser(StorageError):
    code = codes.WH_USER_NEED_INIT

class StorageInitUserImpossibleToLock(StorageInitUser):
    code = codes.USER_INIT_LOCKED

class StorageNoSpace(StorageError):
    code = codes.WH_NO_SPACE_LEFT

class StorageBadRootPath(StorageError):
    code = codes.WH_BAD_ROOT_PATH

class StorageVersionNotFound(StorageError):
    code = codes.VERSION_NOT_FOUND

class StorageNotFound(StorageVersionNotFound, NotFound):
    pass

class StorageKeyNotFound(StorageNotFound):
    code = codes.WH_RESOURCE_NOT_FOUND

class StorageWrongResourceType(StorageError):
    pass

class StorageUpdateWhereFailed(StorageError):
    pass

class StorageWrongVersion(StorageError):
    code = codes.STORAGE_WRONG_VERSION

class StorageDomainNotFound(StorageError):
    pass

class StorageDomainAlreadyExists(StorageError):
    pass

class StorageFolderAlreadyExist(StorageError, ResourceExist):
    pass

class FotkiError(APIError):
    pass

class FotkiNotFound(FotkiError):
    code = codes.FOTKI_NOT_FOUND

class FotkiNoResponse(FotkiError):
    code = codes.FOTKI_NO_RESPONSE

class FotkiBadResponse(FotkiError):
    code = codes.FOTKI_BAD_RESPONSE

class FotkiUserNotFound(FotkiError):
    code = codes.FOTKI_USER_NOT_FOUND

class YaVideoError(APIError):
    pass

class PassportError(APIError):
    pass

class PassportBadResult(PassportError):
    code = codes.PASSPORT_BAD_RESULT

class PassportNoResponse(PassportError):
    code = codes.PASSPORT_NO_RESPONSE

class PassportPasswordNeeded(PassportError):
    code = codes.PASSPORT_PASSWORD_NEEDED

class PassportTokenExpired(PassportError):
    code = codes.PASSPORT_TOKEN_EXPIRED

class PassportCookieInvalid(PassportTokenExpired):
    """Бросается если авторизация не разрешается по куке.

    Возможные кейсы:
      * протухла кука
      * не разрешена авторизация на текущем домене
      * учтеная запись временно заблокирована саппортом
      * некорректный формат куки

    MPFS-код ошибки такой же как для протухшего токена (PassportTokenExpired).
    """

class PassportUserDoesNotExistError(PassportError):
    code = codes.PASSPORT_USER_DOES_NOT_EXIST


class PassportUnknownUIDError(PassportError):
    """В Паспорте не известно о существовании такого uid.

    Отличие от PassportUserDoesNotExistError:
    PassportUserDoesNotExistError - юзер был в Паспорте, но потом его, например, удалили
    PassportUnknownUIDError - uid не известен, не существовал в Паспорте данного окружения
    """
    code = codes.PASSPORT_UNKNOWN_UID


class SocialProxyError(APIError):
    pass

class SocialProxyBadResult(SocialProxyError):
    code = codes.SOCIALPROXY_BAD_RESULT

class SocialProxyNoResponse(SocialProxyError):
    code = codes.SOCIALPROXY_NO_RESPONSE

class SocialProxyAccessDenied(SocialProxyError):
    pass

class SocialProxyNoProfiles(SocialProxyError):
    code = codes.SOCIALPROXY_NO_PROFILES

class SocialError(MPFSError):
    pass

class SocialWrongProviderError(SocialError):
    code = codes.SOCIAL_WRONG_PROVIDER

class SocialProxyRateLimitExceeded(SocialError):
    code = codes.SOCIALPROXY_RATE_LIMIT_EXCEEDED

class SocialProxyInvalidParameters(SocialError):
    code = codes.SOCIALPROXY_INVALID_PARAMETERS

class SocialProxyInvalidToken(SocialError):
    code = codes.SOCIALPROXY_INVALID_TOKEN

class PushError(APIError):
    pass

class PushNoResponse(PushError):
    code = codes.PUSH_NO_RESPONSE

class XivaBadToken(PushError):
    code = codes.XIVA_BAD_TOKEN

class XivaLimitExceeded(PushError):
    code = codes.XIVA_LIMIT_EXCEEDED

class XivaAppNotRegistered(PushError):
    code = codes.XIVA_APP_NOT_REGISTERED

class MailNoResponse(APIError):
    code = codes.MAIL_NO_RESPONSE

class MailBadResponse(APIError):
    code = codes.MAIL_BAD_RESPONSE

class SearchError(APIError):
    pass

class QueueError(MPFSError):
    pass

class QueueJobNotFound(QueueError):
    pass

class QueueNoFreeJobs(QueueError):
    pass

class QueueJobUpdateFailed(QueueError):
    pass

class QueueJobCreateFailed(QueueError):
    pass

class QueueJobFailed(QueueError):
    pass

class QueueNoAsyncTaskDataError(QueueError):
    pass

class NotPermitted(MPFSError):
    pass

class MkdirNotPermitted(NotPermitted):
    code = codes.MKDIR_PERMISSION_DENIED

class RmNotPermitted(NotPermitted):
    code = codes.RM_PERMISSION_DENIED

class PermissionDenied(NotPermitted):
    code = codes.PERMISSION_DENIED

class MetastorageError(MPFSError):
    pass

class MetastorageCommitError(MetastorageError):
    code = codes.METASTORAGE_COMMIT_FAILED

class HardLinkError(MPFSError):
    pass

class HardLinkNotReady(HardLinkError):
    code = codes.HARDLINK_NOT_READY

class HardLinkNotFound(HardLinkError):
    code = codes.HARDLINK_NOT_FOUND

class HardlinkBroken(HardLinkError):
    pass


class HardlinkFileNotInStorage(HardLinkError):
    pass


class Hardlinked(MPFSError):
    pass


class SymlinkError(MPFSError):
    pass

class SymlinkNotFound(SymlinkError):
    code = codes.SYMLINK_NOT_FOUND

class SymlinkNotAllowed(SymlinkError):
    code = codes.SYMLINK_NOT_ALLOWED

class NoFreeSpace(MPFSError):
    code = codes.NO_FREE_SPACE

class SymlinkInvalidPassword(SymlinkError):
    code = codes.SYMLINK_INVALID_PASSWORD

class SymlinkPasswordTokenExpired(SymlinkError):
    code = codes.SYMLINK_PASSWORD_TOKEN_EXPIRED

class SymlinkInvalidPasswordToken(SymlinkError):
    code = codes.SYMLINK_INVALID_PASSWORD_TOKEN

class OwnerHasNoFreeSpace(NoFreeSpace):
    code = codes.OWNER_HAS_NO_FREE_SPACE


class NoFreeSpaceCopy(NoFreeSpace):
    pass

class NoFreeSpaceMoveFromShared(NoFreeSpace):
    pass

class NoFreeSpaceCopyToDisk(NoFreeSpaceCopy):
    code = codes.NO_FREE_SPACE_COPY_TO_DISK

class BadArguments(MPFSError):
    code = codes.CODE_ERROR

class ResourceBlocked(MPFSError):
    code = codes.RESOURCE_BLOCKED

class UserOverdrawn(NoFreeSpace):
    code = codes.USER_OVERDRAWN

class HidBlocked(MPFSError):
    code = codes.HID_BLOCKED

class StidIsAliveError(MPFSError):
    pass

class HiddenStidIsAliveError(MPFSError):
    pass

class DocviewerError(MPFSError):
    pass

class DocviewerUnsupportedType(DocviewerError):
    code = codes.DOCVIEWER_UNSUPPORTED_TYPE

class DocviewerBadToken(DocviewerError):
    code = codes.DOCVIEWER_BAD_TOKEN

class DocviewerNotModifiedError(DocviewerError):
    code = codes.DOCVIEWER_NOT_MODIFIED

class UserError(MPFSError):
    pass

class UserInvitesExcedeed(UserError):
    code = codes.USER_INVITES_EXCEEDED

class UserBlocked(UserError):
    code = codes.USER_BLOCKED

class UserKarmaAllowWhitelist(UserError):
    code = codes.USER_KARMA_WHITELIST

class UserKarmaBad(UserError):
    code = codes.USER_KARMA_BAD

class UserIsReadOnly(UserError):
    code = codes.USER_READ_ONLY

class PublicationError(MPFSError):
    code = codes.PUBLICATION_ERROR

class ViralFilesNotAllowedToPublicate(PublicationError):
    code = codes.VIRAL_FILES_NOT_ALLOWED_TO_PUBLICATE

class BadDeviceParameters(MPFSError):
    pass

class SettingStateNotFound(MPFSError):
    code = codes.RM_NOT_FOUND

class FeatureDisabled(MPFSError):
    code = codes.FEATURE_DISABLED

class AviaryError(APIError):
    pass

class AviaryNoResponse(AviaryError):
    code = codes.AVIARY_NO_RESPONSE

class AviaryBadResponse(AviaryError):
    code = codes.AVIARY_BAD_RESPONSE


class GeocoderError(APIError):
    pass


class GeocoderNoResponse(GeocoderError):
    pass


class StorageUserIsNotSharded(StorageError):
    pass


class StorageNoAliveShardsForRegister(StorageError):
    code = codes.SHARDS_NO_ALIVE_TO_REGISTER


class StorageShardIsReadonly(StorageError):
    pass


class ProfileError(APIError):
    """Базовое исключение для сервиса ProfileService"""


class ProfileNoResponse(ProfileError):
   code = codes.PROFILE_NO_RESPONSE


class ProfileBadResponse(ProfileError):
    code = codes.PROFILE_BAD_RESPONSE


class StorageMigrationFailed(StorageError):
    pass


class DataApiError(APIError):
    """Базовое исключение для сервиса DataApiService"""


class DataApiNoResponse(DataApiError):
    code = codes.DATA_API_NO_RESPONSE


class DataApiBadResponse(DataApiError):
    code = codes.DATA_API_BAD_RESPONSE


class DataApiProfileError(APIError):
    """Базовое исключение для сервиса DataApiService"""


class DataApiProfileNoResponse(DataApiProfileError):
    code = codes.DATA_API_PROFILE_NO_RESPONSE


class DataApiProfileBadResponse(DataApiProfileError):
    code = codes.DATA_API_PROFILE_BAD_RESPONSE


class CommentsError(APIError):
    """Базовое исключение для сервиса CommentsService"""


class CommentsBadResponse(CommentsError):
    code = codes.COMMENTS_BAD_RESPONSE


class NotesError(APIError):
    """Базовое исключение для сервиса NotesService."""


class NotesBadResponse(NotesError):
    code = codes.NOTES_BAD_RESPONSE


class RateLimiterError(APIError):
    """Базовое исключение для сервиса RateLimiterService"""


class RateLimiterNoResponse(DataApiError):
    code = codes.RATE_LIMITER_NO_RESPONSE


class RateLimiterBadResponse(DataApiError):
    code = codes.RATE_LIMITER_BAD_RESPONSE


class EventSystemError(MPFSError):
    """Базовое исключение системы сообщений(издатель-подписчик)"""


class EventError(EventSystemError):
    """Ошибки событий"""


class EventDispatcherError(EventSystemError):
    """Ошибки диспетчера событий"""


class BulkDownloadJsonBodyExpectedError(MPFSError):
    code = codes.BULK_DOWNLOAD_JSON_BODY_EXPECTED


class BulkDownloadNoFilesToDownload(MPFSError):
    code = codes.BULK_DOWNLOAD_NO_FILES_TO_DOWNLOAD


class ResourceLocationMismatch(ResourceNotFound):
    def __init__(self, shard, collection, doc):
        self.shard = shard
        self.collection = collection
        self.doc = doc


class BadTargetUserError(MPFSError):
    code = codes.BAD_TARGET_USER_SPECIFIED


class EventHistoryBadResponse(APIError):
    code = codes.EVENT_HISTORY_BAD_RESPONSE


class JsonBodyExpectedError(MPFSError):
    code = codes.JSON_BODY_EXPECTED


class ConductorError(APIError):
    pass


class HbfError(APIError):
    pass


class RabbitMQCacheFileNotFoundError(MPFSError):
    pass


class RabbitMQCacheBrokenDataError(MPFSError):
    pass


class UserRemoveNotAllowed(MPFSError):
    code = codes.USER_REMOVE_NOT_ALLOWED


class AggregateFailed(MPFSError):
    code = codes.AGGREGATE_FAILED


class UserIsNotB2bError(MPFSError):
    code = codes.USER_IS_NOT_B2B


class XivaError(APIError):
    pass


class PDDError(MPFSError):
    pass


class UserIsNotPDDError(PDDError):
    code = codes.USER_IS_NOT_PDD


class NotifierBadResponse(APIError):
    code = codes.NOTIFIER_BAD_RESPONSE


class RequestsLimitExceeded(APIError):
    code = codes.REQUESTS_LIMIT_EXCEEDED


class SnapshotError(MPFSError):
    pass


class SnapshotSharedFoldersTimeOut(SnapshotError):
    code = codes.SNAPSHOT_SHARED_FOLDERS_TIME_OUT


class SnapshotInfiniteLoopDetected(SnapshotError):
    code = codes.SNAPSHOT_INFINITE_LOOP_DETECTED


class TVMError(APIError):
    pass


class DjfsError(APIError):
    pass


class UsermapUpdateError(StorageError):
    pass


class NonexistentUsermapStatusError(StorageError):
    pass


class SupportError(MPFSError):
    pass


class SupportTooManyUsersWithProhibitedCleaningError(SupportError):
    code = codes.SUPPORT_TOO_MANY_USERS_WITH_PROHIBITED_CLEANING


class StaffUserNotFound(MPFSError):
    code = codes.STAFF_USER_NOT_FOUND


class StaffMoreUsersThanExpected(MPFSError):
    code = codes.STAFF_MORE_USERS_THAN_EXPECTED


class YaTeamDirModifyError(NotPermitted):
    code = codes.YATEAM_DIR_MODIFY_ERROR


class TVM2InvalidTicketError(MPFSError):
    code = codes.TVM_2_0_INVALID_TICKET


class TVM2ClientNotRegisteredError(MPFSError):
    code = codes.TVM_2_0_CLIENT_NOT_REGISTERED


class SignAndTsAuthorizationError(MPFSError):
    code = codes.UNAUTHORIZED


class DeviceSubscriptionNotFound(MPFSError):
    code = codes.DEVICE_SUBSCRIPTION_NOT_FOUND


class AuthorizationError(MPFSError):
    code = codes.UNAUTHORIZED


class APIRestrictedForOverdraftUserError(MPFSError):
    code = codes.API_RESTRICTED_FOR_OVERDRAFT_USER


class TooManyExecutingOperationsError(MPFSError):
    code = codes.TOO_MANY_EXECUTING_OPERATIONS


class TooManyElementsForFullDiffError(SnapshotError):
    code = codes.TOO_MANY_ELEMENTS_FOR_FULL_DIFF


class DjfsApiProxyError(MPFSError):
    def __init__(self, code, data=None):
        self.code = code
        super(DjfsApiProxyError, self).__init__(data=data)


class DjfsAlbumsProxyError(MPFSError):
    def __init__(self, code, data=None):
        self.code = code
        super(DjfsAlbumsProxyError, self).__init__(data=data)


class DjfsApiProxyNotImplementedError(MPFSError):
    pass


class DjfsAlbumsProxyNotImplementedError(MPFSError):
    pass


class UAASResponseError(APIError):
    pass


class UAASRequestInvalidClient(BadRequestError):
    pass


class UAASExpConfigVersionNotFoundError(APIError):
    pass


class PassportUnsupportedEventTypeError(BadRequestError):
    code = codes.PASSPORT_UNSUPPORTED_EVENT_TYPE


class FolderDeletionByResourceIdForbiddenError(BadRequestError):
    code = codes.FOLDER_DELETION_BY_RESOURCE_ID_FORBIDDEN


class MalformedAvatarsStidError(MPFSError):
    pass


class MD5CheckNotSupportedError(BadRequestError):
    code = codes.MD5_CHECK_NOT_SUPPORTED


class RequestsLimitExceeded429(APIError):
    code = codes.REQUESTS_LIMIT_EXCEEDED_429


class SpamError(MPFSError):
    code = codes.SPAM_ERROR


class UserAlreadyReindexedForQuickMove(MPFSError):
    code = codes.USER_ALREADY_REINDEXED_FOR_QUICK_MOVE


class UserCannotBeReindexedForQuickMove(MPFSError):
    code = codes.USER_CANNOT_BE_REINDEXED_FOR_QUICK_MOVE


class TrashAppendIsRunningError(Forbidden):
    code = codes.TRASH_APPEND_IS_RUNNING


class ClientBadRequest(BadRequestError):
    code = codes.CLIENT_BAD_REQUEST


class BulkActionsLimitExceeded(MPFSError):
    code = codes.BULK_ACTIONS_LIMIT_EXCEEDED


class TooManyFilesInListingError(MPFSError):
    code = codes.TOO_MANY_FILES_IN_LISTING


class VideoStreamingUnprocessableEntity(APIError):
    code = codes.VIDEO_STREAMING_UNPROCESSABLE_ENTITY


class AlbumItemCanNotBeMoved(MPFSError):
    code = codes.ALBUM_ITEM_CAN_NOT_BE_MOVED

class FailoverFileIsTooOld(MPFSError):
    code = codes.FAILOVER_FILE_IS_TOO_OLD


class OnlineEditorUnknow(MPFSError):
    code = codes.ONLINE_EDITOR_UNKNOW


class TelemostApiError(APIError):

    def __init__(self, code):
        self.code = code


class TelemostApiNoResponse(TelemostApiError):
    pass


class TelemostApiBadResponse(TelemostApiError):
    pass


class TelemostApiNotFound(TelemostApiError):
    pass


class TelemostApiForbidden(TelemostApiError):
    pass


class TelemostApiBadRequest(TelemostApiError):
    pass


class TelemostApiGone(TelemostApiError):
    pass


class TelemostApiNotCome(TelemostApiError):
    def __init__(self, code, data=None):
        self.code = code
        self.data = data


class TelemostApiForbiddenToPrivate(TelemostApiError):
    pass


class TelemostApiConflict(TelemostApiError):
    pass


class TelemostOverload(TelemostApiError):
    pass


class TelemostApiStreamNotStarted(TelemostApiError):
    pass


class TelemostApiBroadcastLinkExpired(TelemostApiError):
    pass


class TelemostApiNoSuchBroadcastCreated(TelemostApiError):
    pass


class TelemostApiInvalidTranslatorToken(TelemostApiError):
    pass


class TelemostApiNoSuchUserInConference(TelemostApiError):
    pass

class TelemostApiForbiddenAccessToCreateBroadcast(TelemostApiError):
    pass

class TelemostApiForbiddenAccessToStartBroadcast(TelemostApiError):
    pass


class PsBillingError(APIError):

    def __init__(self, code):
        self.code = code


class PsBillingNoResponse(PsBillingError):
    pass


class PsBillingBadResponse(PsBillingError):
    def __init__(self, code, data=None):
        self.code = code
        self.data = data


class PsBillingNotFound(PsBillingError):
    pass


class PsBillingForbidden(PsBillingError):
    pass


class PsBillingBadRequest(PsBillingError):
    pass


class PsBillingGone(PsBillingError):
    pass


class PsBillingConflict(PsBillingError):
    pass


class OrchestratorError(MPFSError):
    pass


class OrchestratorNotFoundError(OrchestratorError):
    pass


class OrchestratorSessionInactiveError(OrchestratorError):
    pass


class InternalServerError(MPFSError):
    code = INTERNAL_ERROR
