# -*- coding: utf-8 -*-
from mpfs.common.errors import (MPFSError, APIError)
from mpfs.common.static import codes


class BillingError(MPFSError):
    pass


class BillingEntityAlreadyExists(BillingError):
    pass


class BigBillingNotResponse(APIError, BillingError):
    pass


class BigBillingBadResult(APIError, BillingError):
    pass


class BigBillingUnknownMode(APIError, BillingError):
    pass


class BillingWrongMarket(BillingError):
    pass


class BillingClientError(BillingError):
    pass


class BillingProductError(BillingError):
    pass


class BillingPaymentError(BillingError):
    pass


class BillingProductNotFound(BillingProductError):
    pass


class BillingProductHasNoPeriod(BillingProductError):
    pass


class BillingProductHasNoBorder(BillingProductError):
    pass


class BillingProductNotProlongable(BillingProductError):
    pass


class BillingProductIsSingletone(BillingProductError):
    code = codes.BILLING_PRODUCT_SINGLETON

    def __init__(self, name, prev_created_service_info=None, *args, **kwargs):
        super(BillingProductIsSingletone, self).__init__(*args)
        if prev_created_service_info is None:
            prev_created_service_info = {}
        self.previously_created_service_info = prev_created_service_info


class BillingProductAltAttrsNotAllowed(BillingProductError):
    pass


class BillingProductHasNoAttribute(BillingProductError):
    pass


class BillingProductAutoProlongateNotAllowed(BillingProductError):
    pass


class BillingInvalidMarketLineProduct(BillingProductError):
    pass


class BillingGroupOrderDuplicateUids(BillingError):
    pass


class BillingGroupOrderLimitFailed(BillingError):
    pass


class BillingClientNotBindedToMarket(BillingClientError):
    code = codes.BILLING_CLIENT_NOT_BINDED_TO_MARKET


class BillingEntityNotFound(BillingError):
    pass


class BillingOrderNotFound(BillingEntityNotFound):
    code = codes.BILLING_ORDER_NOT_FOUND


class BillingOrderStatusConflict(BillingError):
    pass


class BillingSubscriptionNotFound(BillingEntityNotFound):
    code = codes.BILLING_ORDER_NOT_FOUND


class BillingServiceError(BillingError):
    pass


class BillingServiceNotFound(BillingServiceError, BillingEntityNotFound):
    code = codes.BILLING_SERVICE_NOT_FOUND


class BillingServiceHasAutoProlongate(BillingServiceError):
    pass


class BillingServiceHadAutoProlongate(BillingServiceError):
    pass


class BillingServiceCannotCalculateNextBillingDate(BillingError):
    pass


class BillingServiceAttributeViolated(BillingServiceError):
    pass


class BillingPaymentMethodNotFound(BillingPaymentError):
    pass


class BillingPaymentMethodNotAllowed(BillingPaymentError):
    code = codes.BILLING_PAYMENT_NOT_ALLOWED


class BigBillingBadPaymentResult(BigBillingBadResult):
    pass


class BillingOrderUnexpectedStateError(BillingError):
    pass


class BillingUnexpectedTemplateTag(BillingPaymentError):
    response = 400
    code = codes.BILLING_UNEXPECTED_TEMPLATE_TAG
    message = 'Unexpected template_tag value'


class BillingUnableToChangeOrderState(BillingError):
    response = 409
    code = codes.BILLING_UNABLE_TO_CHANGE_ORDER_STATE
    message = 'Changing order state to particular value violates common flowchart'


class BillingCannotBuyProductFromNotCheapestLineAvailable(BillingError):
    response = 400
    code = codes.BILLING_CANNOT_BUY_PRODUCT_FROM_NOT_CHEAPEST_LINE_AVAILABLE
    message = 'Can\'t buy a product from not the cheapest line available, try different product_id'


class BillingRefundRetryError(BillingError):
    code = codes.BILLING_UNABLE_TO_RETRY_REFUND


class BillingPaymentNotFoundError(BillingError):
    code = codes.BILLING_PAYMENT_NOT_FOUND


class BillingPaymentNotRefundableError(BillingError):
    code = codes.BILLING_PAYMENT_NOT_REFUNDABLE


class BillingRefundNotFoundError(BillingError):
    code = codes.BILLING_REFUND_NOT_FOUND


class BillingInAppStoreSubNotFoundForParticularOTID(BillingError):
    code = codes.BILLING_INAPP_STORE_SUB_NOT_FOUND_FOR_PARTICULAR_OTID


class BillingInAppStoreIdsOfProductAndRequestMismatch(BillingError):
    code = codes.BILLING_IN_APP_STORE_IDS_OF_PRODUCT_AND_REQUEST_MISMATCH


class BillingInAppInvalidVerification(BillingError):
    code = codes.BILLING_IN_APP_INVALID_VERIFICATION


class BillingInAppUidMismatch(BillingError):
    code = codes.BILLING_IN_APP_UID_MISMATCH


class BillingTrustInvalidVerification(BillingError):
    code = codes.BILLING_TRUST_INVALID_VERIFICATION


class BillingTrustSyncError(BillingError):
    code = codes.BILLING_TRUST_INVALID_SYNCHRONIZATION


class BillingTrustUIDSyncError(BillingError):
    code = codes.BILLING_TRUST_INVALID_UID_SYNCHRONIZATION


class BillingInAppUnsupportedStoreIdError(BillingError):
    code = codes.BILLING_IN_APP_UNSUPPORTED_STORE_ID


class MediaBillingError(BillingError):
    pass


class MediaBillingStatusError(BillingError):
    pass


class TrustInAppSubscriptionStateNotSynchronized(ValueError):
    pass


class TrustInAppSubscriptionStateUnexpected(ValueError):
    pass
