# -*- coding: utf-8 -*-
"""
MPFS Base Exceptions
"""
from mpfs.common.static import codes
from mpfs.common.static import messages


class MPFSRootException(Exception):
    code = codes.MPFS_ERROR
    default_response_code = messages.default_caught_response
    log = False
    headers = None
    """Содержит значения, которые надо прокинуть в хэдере"""

    def __init__(self, *args, **kwargs):
        super(MPFSRootException, self).__init__(*args)
        self.extra_msg = (': ' + kwargs['extra_msg']) if kwargs.get('extra_msg') else ''
        self.title = kwargs.get('title')
        self.data = kwargs.get('data')
        self.headers = kwargs.get('headers')

    def repr(self):
        result = {
                  'code' : self.code,
                  'message' : self.message,
                  'response' : getattr(self, 'response', messages.default_response),
                  }
        return result


class MPFSError(MPFSRootException):
    response = messages.default_caught_response

    def __init__(self, *args, **kwargs):
        super(MPFSError, self).__init__(*args, **kwargs)
        if self.title is None:
            self.message = messages.titles.get(self.code, str(self.__class__.__name__)) + self.extra_msg
        else:
            self.message = self.title
        self.response = messages.responses.get(self.code, self.default_response_code)


class APIError(MPFSError):
    default_response_code = messages.default_apierror_response

    def get_status_code(self):
        return int(self.response)

    def set_status_code(self, value):
        self.response = int(value)

    # status_code is more convenient and intuitive then response, that can means either full HTTP response
    # or just its body, or something else
    status_code = property(get_status_code, set_status_code)