# -*- coding: utf-8 -*-

from mpfs.common.static import codes
from mpfs.common.errors import MPFSError


class LentaError(MPFSError):
    pass


class LentaTooLargeBlockSizeError(LentaError):
    code = codes.LENTA_TOO_LARGE_BLOCK_SIZE


class LentaEmptyBlockError(LentaError):
    code = codes.LENTA_EMPTY_BLOCK


class LentaNoRequestBodyError(LentaError):
    code = codes.LENTA_NO_REQUEST_BODY


class LentaNotSupportedBlockTypeError(LentaError):
    code = codes.LENTA_NOT_SUPPORTED_BLOCK_TYPE
