# -*- coding: utf-8 -*-


from mpfs.common.static import codes
from mpfs.common.errors import MPFSError, NoFreeSpace, ResourceNotFound


class ShareError(MPFSError):
    pass

class ShareNotFound(ShareError, ResourceNotFound):
    pass

class GroupNotFound(ShareNotFound):
    code = codes.GROUP_NOT_FOUND


class GroupConflict(ShareError):
    code = codes.GROUP_CONFLICT


class ShareRightsNotChanged(ShareError):
    pass


class ShareInviteRightsNotChanged(ShareRightsNotChanged):
    pass


class ShareMemberRightsNotChanged(ShareRightsNotChanged):
    pass


class GroupNoPermit(ShareError):
    code = codes.GROUP_NOT_PERMIT


class GroupInviteNotFound(ShareError):
    code = codes.GROUP_INVITE_NOT_FOUND


class GroupInviteExpired(ShareError):
    code = codes.GROUP_INVITE_EXPIRED


class GroupUserInvited(ShareError):
    code = codes.GROUP_USER_INVITED


class ShareUserLimitReached(ShareError):
    code = codes.SHARE_USERS_LIMIT_REACHED
    log = True


class ShareGroupsLimitReached(ShareError):
    code = codes.SHARE_GROUPS_LIMIT_REACHED
    log = True


class ShareFoldersLimitReached(ShareError):
    code = codes.SHARE_FOLDERS_LIMIT_REACHED
    log = True


class StorageEndpointError(ShareError):
    code = codes.DATABASE_ENDPOINT_ERROR


class RootPublication(ShareError):
    pass


class GroupNoFreeSpace(NoFreeSpace):
    pass
