# -*- coding: utf-8 -*-


import operator
import exceptions

from mpfs.common.util import natsort
import mpfs.engine.process

log = mpfs.engine.process.get_default_log()

class BaseForm(object):

    def __init__(self, model):
        self.model = model


class ResourceForm(BaseForm):

    def __init__(self, model):
        super(ResourceForm, self).__init__(model)
        self.args = {'filter' : {}, 'bounds' : {}}

    def __getattribute__(self, *args, **kwargs):
        k = args[0]
        try:
            if args[0].startswith('model__'):
                k = args[0].split('model__', 1)[1]
                raise exceptions.AttributeError()
            elif args[0].startswith('form__'):
                k = args[0].split('form__', 1)[1]
            result = super(BaseForm, self).__getattribute__(*[k], **kwargs)
        except exceptions.AttributeError, ae:
            if args[0].startswith('form__'):
                raise
            try:
                try:
                    result = getattr(self.model, k)
                except AttributeError:
                    result = self.model.meta[k]
                if k == 'mimetype':
                    if result in ('application/octet-stream', 'multipart/form-data', 'application/x-www-form-urlencoded'):
                        result = ''
            except exceptions.KeyError:
                raise ae
        return result

    def is_dir(self):
        return self.model.is_folder

    def apply_filter(self, resource_data, fields):
        '''
            assert fltr values equal to src
        '''
        def _filt(fkys, dkys, dta):
            if not fkys or not dta:
                return True
            elif fkys.issubset(dkys):
                gttr = operator.itemgetter(*fkys)
                return gttr(dta) == gttr(fields)
            else:
                return False
        if fields:
            res_set = set(resource_data)
            flt_set = set(fields)
            meta_keys = flt_set - res_set
            main_keys = flt_set - meta_keys
            return _filt(main_keys, res_set, resource_data) and _filt(meta_keys, res_set, resource_data.get('meta', {}))
        else:
            return True

    def apply_filters(self):
        pass

    def apply_bounds(self):
        pass

    def list(self):
        pass

    def get_media_type(self):
        return natsort.get_extension(self.name)

    def dict(self):
        result = {}
        result.update(self.model.dict())
        meta = result.pop('meta')
        result.update(meta)
        return result
