# -*- coding: utf-8 -*-

import mpfs.engine.process

from mpfs.common.forms import ResourceForm
from mpfs.common.util import docviewer_types
from mpfs.common.util import filetypes
from mpfs.common.static.tags import META, MEDIATYPE

log = mpfs.engine.process.get_default_log()

class FileForm(ResourceForm):

    def __init__(self, model):
        ResourceForm.__init__(self, model)
        if hasattr(model, 'media_type') and model.media_type:
            self.media_type = model.media_type
#         elif self.model.address.storage_name in ('mail','narod', 'fotki'):
#             self.media_type = filetypes.getGroupByName(self.model__name, mtype=self.model__mimetype)
        else:
            self.media_type = filetypes.getGroupByName(self.model__name, mtype=self.model__mimetype)
#             self.media_type = filetypes.getGroupByMimetype(self.model__mimetype, self.model__name)
        #=======================================================================
        # MS docviewer style
        # docv_query = docviewer_types.find_mime(
        #    mime=self.mimetype,
        #    ext=self.name
        # )
        # self.docviewer_type = docv_query.get('dtype') if docviewer_types.get_ready(self.name) else ''
        #=======================================================================
        self.docviewer_type = None
        if self.size != 0:
            self.docviewer_type = docviewer_types.get_docviewer_type(mime=self.mimetype, ext=self.name)
        self.file_icon = docviewer_types.get_icon_val(self.name, self.mimetype, self.media_type)

    def dict(self):
        result = super(FileForm, self).dict()
        result[MEDIATYPE] = self.media_type
        return result