# -*- coding: utf-8 -*-
import exceptions

from copy import copy


import mpfs.engine.process


log = mpfs.engine.process.get_default_log()


class BaseFilter(object):

    field = ''

    def __init__(self, field, value):
        if isinstance(value, (str, unicode)):
            value = value.split(',')
        elif not isinstance(value, (list, tuple)):
            value = (value,)
        self.value = map(int, filter(lambda x: isinstance(x, (str, unicode)) and x.isdigit(), value)) or value
        self.field = field


    def get_resource_value(self, resource):
        try:
            val = getattr(resource, self.field)
        except exceptions.AttributeError:
            val = resource.meta.get(self.field)
        return val


    def check_form(self, form):
        if hasattr(form, self.field):
            res = getattr(form, self.field) in self.value
            return res
        else:
            return False


class GapFilter(BaseFilter):

    def __init__(self, value, field=''):
        super(GapFilter, self).__init__(value, field)
        self.value = map(int, self.value)


    def check_form(self, form):
        if not hasattr(form, self.field):
            return False
        val = getattr(form, self.field)
        def _check_couple(seq):
            if seq and not len(seq) % 2:
                start = seq.pop(0)
                end = seq.pop(0)
                res = val >= start and val <= end
                if seq:
                    return res or _check_couple(seq)
                else:
                    return res

        return _check_couple(copy(self.value))
