# -*- coding: utf-8 -*-


import operator

from mpfs.common.util import natsort
from mpfs.common.forms.folder import FolderForm, State
from mpfs.common.forms import filters

import mpfs.engine.process
log = mpfs.engine.process.get_default_log()


class MixedState(State):
    def __init__(self):
        super(MixedState, self).__init__()
        self.resources_filtered = False

class MixedForm(FolderForm):

    
    def __init__(self, model):
        super(MixedForm, self).__init__(model)
        self.child_resources = []
        self._state = MixedState()
        self._chunk_resources_size = 0
        
    @property
    def totally_filtered(self):
        return self._totally_filtered or len(self.all_resources())

    @property
    def numresources(self):
        return self.model__numresources or len(self.model.children_list)
    
    @property
    def chunk_numresources(self):
        return self._chunk_resources_size or len(self.resources())

    
    def resources(self): 
        if (not self.child_resources and not self._state.resources_filtered
            and not self._state.amount_applied):
            for item in self.model.children_list:
                self.child_resources.append(item.form)
        return self.child_resources


    def all_resources(self, root=True, cut=False):
        result = []
        result.extend(self.resources())
        for item in self.resources():
            result.extend(item.all_resources(False))
        if root:
            result = self._manage_resources(result)
        if cut:
            if 'offset' in self.args['bounds']:
                result = result[self.args['bounds']['offset']:]
            if 'amount' in self.args['bounds']:
                result = result[:self.args['bounds']['amount']]
        self._chunk_resources_size = len(result)
        return result


    def apply_filters(self):
        if self.args['filter']:
            self.child_resources = self._filter(self.resources())
            self._state.resources_filtered = True
            


    def order(self):
        if not self._state.order_applied:
            order = bool(self.args['bounds'].get('order'))
            if not order:
                self.child_resources = reversed(self.resources())
            self._state.order_applied = True


    def sort(self):
        if not self._state.sort_applied:
            sort_field = self.args['bounds']['sort']
            order = bool(self.args['bounds'].get('order', 1))
            resources = self.resources()
            self.child_resources = self._sort(resources, sort_field, order)
            self._state.sort_applied = True
            self._state.order_applied = True


    def cutoff(self):
        resources = self.resources()
        self._totally_filtered = self._totally_filtered or len(resources)
        if not self._state.offset_applied:
            offset = int(self.args['bounds'].get('offset', 0))
            if offset:
                resources = resources[offset:]
            self._state.offset_applied = True
        if not self._state.amount_applied:
            amount = int(self.args['bounds'].get('amount', 0))
            if amount:
                resources = resources[:amount]
            self._state.amount_applied = True
        self._chunk_resources_size = len(resources)
        self.child_resources = resources
        

 