# -*- coding: utf-8 -*-

from pkg_resources import require
require("CherryPy")

import cherrypy


class HeaderMapRFC822(cherrypy._cphttptools.httptools.HeaderMap):
    '''
        Standart HeaderMap works with RFC 2047.
        This Map doesn't modify headers' encoding and works with RFC822.
    '''
    def sorted_list(self, protocol=(1, 0)):
        header_list = []
        for key, valueList in self.iteritems():
            order = self.order_map.get(key, 3)
            if not isinstance(valueList, list):
                valueList = [valueList]
            for v in valueList:

                if isinstance(v, unicode):
                    try:
                        v = v.encode("utf-8")
                    except UnicodeEncodeError:
                        if protocol >= (1, 1):
                            from email.Header import Header
                            v = Header(v).encode()
                        else:
                            raise
                    pass
                else:
                    v = str(v)

                header_list.append((order, (key, v)))
        header_list.sort()
        return [item[1] for item in header_list]


cherrypy._cphttptools.httptools.HeaderMap = HeaderMapRFC822
