# -*- coding: utf-8 -*-
"""

MPFS

Словарь системных сообщений

"""

from mpfs.common.static.codes import *


titles = {
    METHOD_NOT_IMPLEMENTED : "method not implemented",
    TREE_BAD_PATH : "tree: bad formed path",
    TREE_NOT_FOLDER : "tree: not a folder",
    TREE_NOT_FOUND : "tree: folder was not found",
    TREE_PERMISSION_DENIED : "tree: view permission denied",

    LIST_BAD_PATH : "list: bad formed path",
    LIST_NOT_FOLDER : "list: not a folder",
    LIST_NOT_FOUND : "list: folder was not found",
    LIST_PERMISSION_DENIED : "list: view permission denied",

    MKDIR_BAD_PATH : "mkdir: bad formed path",
    MKDIR_NOT_FOLDER : "mkdir: not a folder",
    MKDIR_NOT_FOUND : "mkdir: parent folder was not found",
    MKDIR_PERMISSION_DENIED : "mkdir: folder creation was denied",
    MKDIR_NOT_IMPLEMENTED : "mkdir: not implemented",
    MKDIR_EXISTS: "mkdir: resource already exists",

    RM_BAD_PATH : "rm: bad formed path",
    RM_NOT_FOUND : "rm: not found",
    RM_NOT_FOLDER : "rm: not a folder",
    RM_PERMISSION_DENIED : "rm: resource removal is not permitted",
    RM_NOT_IMPLEMENTED : "rm: not implemented",

    STORE_NOT_FOUND : "store: parent folder was not found",
    STORE_UNKNOWN : "store: file cannot be stored",

    INFO_BAD_PATH : "info: bad formed path",
    INFO_NOT_FILE : "info: not a file",
    INFO_NOT_FOUND : "info: was not found",
    INFO_PERMISSION_DENIED : "info: access was denied",
    INFO_EXISTS: "info: already exists",

    URL_BAD_PATH : "url: bad formed path",
    URL_NOT_FILE : "url: not a file",
    URL_NOT_FOUND : "url: was not found",
    URL_PERMISSION_DENIED : "url: access was denied",

    GENERIC_ERROR_COPY : "copy: unidentified error",
    COPY_NOT_FOUND : "copy: source was not found",
    COPY_D2D_RESOURCE_EXISTS : "copy: resource already exists",
    COPY_FROM_DISK_ERROR : "can't copy from disk",

    OPERATION_NOT_FOUND : "operation: not found",
    OPERATION_CLASS_NOT_FOUND : "operation: class not found",

    KLADUN_NO_RESPONSE : "No response from Kladun",
    NAROD_NO_RESPONSE : "Narod isn't responding",
    NAROD_BAD_RESPONSE : "Bad response from Narod",
    WH_NO_RESPONSE : "No response from Storage",
    FOTKI_NO_RESPONSE : "No response from Fotki",
    FOTKI_BAD_RESPONSE : "Bad response from Fotki",
    MAIL_NO_RESPONSE : "No response from Mail",
    MAIL_BAD_RESPONSE : "Bad response from Mail",
    PUSH_NO_RESPONSE : "No response from push listener",
    XIVA_BAD_TOKEN : "Bad token received for Xiva",
    XIVA_LIMIT_EXCEEDED : "Xiva filter size limit exceeded",
    XIVA_APP_NOT_REGISTERED: "Xiva application is not registered",

    SETPROP_NOT_FOUND : "setprop: resource not found",

    MOVE_NOT_FOUND : "move: source was not found",

    DIFF_NOT_FOUND : "diff: source was not found",
    COPY_SAME_RESOURCE : "copy: same resource as target",
    WH_USER_NEED_INIT : "WH: user is not initialized",
    WH_NO_SPACE_LEFT : "WH: no free space",
    FOTKI_USER_NOT_FOUND : "Fotki: user not found",
    STORE_FILE_EXISTS : "Store: file already exists",
    SERVICE_NOT_FOUND : "Service not found",
    WH_ERROR : "Storage unknown error",
    SETPROP_STATIC_FIELDS : "setprop: static fields can't be changed",
    SETPROP_INTERNAL_FIELDS : "setprop: internal fields can't be changed",
    WH_BAD_ROOT_PATH : "WH: bad path",
    MOVE_SAME_RESOURCE : "move: same source as target",
    KLADUN_STATUS_FAILURE : "Kladun error in status",
    KLADUN_HARDLINK_FOUND : "Kladun hardlink found",
    KLADUN_FILE_MODIFIED_BETWEEN_CALLBACKS: "Kladun file was modified between 2 and 3 callbacks",
    METASTORAGE_COMMIT_FAILED : "Unable to fix changes in WH, please, try again later",
    WH_RESOURCE_NOT_FOUND : "Resource not found in WH",
    DSTORE_FILE_NOT_MATCH : "md5 doesn't match",
    HARDLINK_NOT_FOUND : "hardlink not found",
    NO_FREE_SPACE_COPY_TO_DISK : "unable to copy resource: not enough space",
    MULCA_NO_RESPONSE : "No response from Mulca",
    ZABERUN_NO_RESPONSE : "No response from Zaberun",
    COPY_PARENT_NOT_FOUND : "Target parent not found",
    NOT_FILE : "Found folder with same id",
    NOT_FOLDER : "Found file with same id",
    PASSPORT_NO_RESPONSE : "No response from Passport",
    PASSPORT_BAD_RESULT : "Passport: bad result",
    PASSPORT_UNKNOWN_UID: 'Passport: unknown user',
    FOTKI_NOT_FOUND : "Fotki: resource not found",
    FILE_NOT_FOUND : "file not found",
    FOLDER_NOT_FOUND : "folder not found",
    RESOURCE_NOT_FOUND : "resource not found",
    FILE_EXISTS : "file already exists",
    VERSION_NOT_FOUND : "version not found",
    NOT_FOUND : "Not found",
    KLADUN_OPERATION_NOT_FOUND : "Operation not found",
    HARDLINK_NOT_READY: "hardlink not ready",
    PATH_ERROR : "Wrong path",
    CLCK_NO_RESPONSE : "No response from Clck",
    PERMISSION_DENIED: "Not permitted",
    RESOURCE_EXISTS : "Resource already exists",
    EMPTY_FIELDS : "Some of main parameters are empty, check them",
    NO_FREE_SPACE : "Unable to store file: no free space within limit",
    USER_OVERDRAWN: "Space limit exceeded",
    SYMLINK_NOT_FOUND : "Symlink not found",
    SYMLINK_NOT_ALLOWED : "Symlink not allowed",
    SYMLINK_INVALID_PASSWORD: "Symlink invalid password",
    DECRYPTION_ERROR : "Decryption error",
    SERVICES_BAD_PATH : "services: bad formed path",
    SERVICES_NOT_FOLDER : "services: not a folder",
    SERVICES_NOT_FOUND : "services: folder was not found",
    SERVICES_PERMISSION_DENIED : "services: view permission denied",
    STORAGE_WRONG_VERSION : "wrong save version for save in storage",
    RESOURCE_BLOCKED : "resource blocked",
    HID_BLOCKED : "hardlink id blocked",
    KLADUN_CONFLICT : "kladun conflict",
    MPFS_TIMEOUT : "timeout exceed",
    DOCVIEWER_UNSUPPORTED_TYPE : "docviewer not support this file type",
    DOCVIEWER_BAD_TOKEN : 'docviewer got bad or out of time token',
    SET_PUBLIC_NOT_FILE : 'not a file, can`t publicate',
    USER_INVITES_EXCEEDED : 'invites excedeed',
    PUBLICATION_ERROR : 'publication failed',
    STORAGE_ADDRESS_ERROR : 'cannot modify storage address',
    RESOURCE_LOCKED : 'resource is locked',
    VIRAL_FILES_NOT_ALLOWED_TO_PUBLICATE : 'cannot publicate viral files',
    GROUP_NOT_FOUND : 'group not found',
    GROUP_CONFLICT : 'conflict',
    GROUP_NOT_PERMIT : 'operation not permit',
    GROUP_INVITE_NOT_FOUND : 'invite not found',
    GROUP_INVITE_EXPIRED : 'invite expired',
    GROUP_USER_INVITED : 'user has been invited',
    PASSPORT_PASSWORD_NEEDED : 'account has no password',
    PASSPORT_TOKEN_EXPIRED: 'expired or incorrect OAuth token',
    SOCIALPROXY_BAD_RESULT : "social proxy: bad result",
    SOCIALPROXY_NO_RESPONSE : "social proxy: no response",
    SOCIAL_WRONG_PROVIDER : 'social: wrong provider',
    PARTIAL_DIFF : 'storage returned partial diff',
    SIZE_NOT_FOUND : 'total or trash size value not found',
    PRECONDITIONS_FAILED : 'preconditions failed',
    USER_BLOCKED: 'user blocked',
    SOCIALPROXY_NO_PROFILES: "social proxy: no profiles",
    DOCVIEWER_NOT_MODIFIED : "docviewer: not modified",
    MOVE_PARENT_CHILD_RESOURCE : "move: can't move parent to child",
    SHARE_USERS_LIMIT_REACHED : "maxmim users number reached",
    SHARE_GROUPS_LIMIT_REACHED : "maxmim groups number reached",
    SHARE_FOLDERS_LIMIT_REACHED : "maxmim folders number reached",
    MOVE_WRONG_DESTINATION : "wrong destination for move",
    USER_KARMA_WHITELIST : 'bad karma, whitelisting allowed',
    USER_KARMA_BAD : 'bad karma',
    BROWSER_WRONG_TYPE : 'wrong type',
    BROWSER_NO_TYPE : 'no type provided',
    SYNC_STATE_NOT_FOUND : 'states not found',
    SYNC_STATE_VERSION_MISMATCH: 'version mismatch',
    BILLING_CLIENT_NOT_BINDED_TO_MARKET: 'client not binded to market',
    BILLING_ORDER_NOT_FOUND: 'order not found',
    BILLING_SERVICE_NOT_FOUND: 'service not found',
    BILLING_PAYMENT_NOT_ALLOWED: 'payment method not allowed at market',
    COPY_INFECTED_FILE: 'cannot copy infected file',
    SYNC_OUTDATED_TYPE_VERSION : 'received outdated version',
    FEATURE_DISABLED: 'feature disabled in config',
    SOCIALPROXY_INVALID_TOKEN: 'social proxy: invalid token',
    KLADUN_UNEXPECTED_CALLBACK_STATE: 'unexpected state on kladun callback',
    USER_READ_ONLY: 'user is read-only',
    DEVICE_SUBSCRIPTION_NOT_FOUND: 'xiva device subscription not found',

    ALBUMS_IS_NOT_PUBLIC: 'album is not public',
    ALBUM_ITEM_MISSED: 'album\'s item was not found',

    SHARDS_NO_ALIVE_TO_REGISTER: 'no alive shards to register',

    OFFICE_UNAUTHORIZED: 'wrong or expired access_token',
    OFFICE_UNSUPPORTED_ACTION: 'unsupported action',
    OFFICE_UNSUPPORTED_EXTENSION: 'unsupported file extension',
    OFFICE_BAD_RESOURCE_ID: 'unable to parse resource_id',
    OFFICE_FILE_TOO_LARGE: 'file too large',
    OFFICE_NO_HANDLER_FOUND: 'no action handler found',
    OFFICE_PATH_NOT_SPECIFIED: 'path not specified',
    OFFICE_SERVICE_ID_NOT_SPECIFIED: 'service id not specified',
    OFFICE_SERVICE_FILE_ID_NOT_SPECIFIED: 'service file id not specified',
    OFFICE_INVALID_PARAMETERS: 'extension, size and filename must be specified',
    OFFICE_MAIL_ATTACHMENT_NOT_FOUND: 'mail attachment not found',
    OFFICE_FILE_IS_READ_ONLY: 'file is read-only',

    BROWSER_OUTDATED_VERSION: 'received outdated version',
    BROWSER_OBJECT_NOT_FOUND: 'object not found',

    OFFICE_NO_FREE_SPACE_KLADUN_ERROR: 'no free space',
    OFFICE_SIZE_CONSTRAINT_FAILED_KLADUN_ERROR: 'office size limit failed',
    USER_REMOVE_NOT_ALLOWED: 'user remove not allowed',
    SHARD_NOT_AVAILABLE: 'shard not available',
    USER_IS_NOT_B2B: 'user is not a b2b user',

    LENTA_LOADER_NO_RESPONSE: 'no response from lenta loader',
    FORBIDDEN: 'forbidden',
    API_RESTRICTED_FOR_OVERDRAFT_USER: 'API unavailable. Files exceed available storage space. Delete unnecessary files or increase your Yandex.Disk storage space.',

    USER_IS_NOT_PDD: 'User is not a PDD user',

    REQUESTS_LIMIT_EXCEEDED: 'Request per second limit exceeded for user',
    REQUESTS_LIMIT_EXCEEDED_429: 'Request per second limit exceeded for user',

    TVM_2_0_INVALID_TICKET: 'TVM 2.0 ticket validation has failed',
    TVM_2_0_CLIENT_NOT_REGISTERED: 'TVM 2.0 client ID not registered as a MPFS client',

    PASSPORT_UNSUPPORTED_EVENT_TYPE: 'unsupported event type',

    USER_INIT_LOCKED: 'another user init already in progress',
    MD5_CHECK_NOT_SUPPORTED: 'md5 check supported only for files',

    SPAM_ERROR: 'spam',

    USER_ALREADY_REINDEXED_FOR_QUICK_MOVE: 'user has been already reindexed for quick move',
    USER_CANNOT_BE_REINDEXED_FOR_QUICK_MOVE: 'user is in mongo and cannot be reindexed for quick move',

    BILLING_UNABLE_TO_RETRY_REFUND: 'Unable to retry refund',
    BILLING_PAYMENT_NOT_FOUND: 'Payment to refund is not found',
    BILLING_PAYMENT_NOT_REFUNDABLE: 'Payment is not refundable',
    BILLING_REFUND_NOT_FOUND: 'Refund not found for order',

    BULK_ACTIONS_LIMIT_EXCEEDED: 'The bulk request contains too many actions',
    TOO_MANY_FILES_IN_LISTING: 'Too many files in directory listing',
    FOLDER_TOO_DEEP: 'Folder depth limit exceeded',
    OVERDRAFT_USER_PUBLIC_LINK_IS_DISABLED: 'Overdraft user public link not allowed',
    PUBLIC_LINK_SETTINGS_IS_DISABLED: 'Public link settings is not allowed for user',
    OFFICE_ONLY_OFFICE_USER_LIMIT_REACHED: 'Too many users are editing the document',
    OFFICE_ONLY_OFFICE_FILES_LIMIT_REACHED: 'Too many documents are open for editing',
    OFFICE_ONLY_OFFICE_PUBLIC_FILES_LIMIT_REACHED: 'Too many public documents are open for editing',
    OFFICE_ONLY_OFFICE_OUTDATED_DATA: 'Received data is outdated',

    INTERNAL_ERROR: 'Internal server error',
}

responses = {
    NO_FREE_SPACE : 507,
    OWNER_HAS_NO_FREE_SPACE: 507,
    METHOD_NOT_IMPLEMENTED: 405,
    LIST_BAD_PATH : 404,
    LIST_NOT_FOUND : 404,
    MKDIR_NOT_FOUND : 409,
    MKDIR_NOT_FOLDER : 409,
    MKDIR_EXISTS : 405,
    RM_NOT_FOUND : 404,
    STORE_NOT_FOUND : 409,
    STORE_UNKNOWN : 412,
    STORE_FILE_EXISTS: 412,
    INFO_NOT_FOUND : 404,
    URL_NOT_FOUND : 404,
    URL_NOT_FILE : 404,
    URL_BAD_PATH : 400,
    COPY_D2D_RESOURCE_EXISTS : 412,
    SETPROP_NOT_FOUND : 404,
    MOVE_NOT_FOUND : 404,
    COPY_NOT_FOUND : 404,
    DIFF_NOT_FOUND : 404,
    WH_NO_SPACE_LEFT : 507,
    KLADUN_NO_RESPONSE: 503,
    MULCA_NO_RESPONSE: 503,
    WH_NO_RESPONSE: 503,
    NAROD_NO_RESPONSE: 503,
    NAROD_BAD_RESPONSE: 503,
    FOTKI_NO_RESPONSE: 503,
    FOTKI_BAD_RESPONSE: 503,
    ZABERUN_NO_RESPONSE: 503,
    MAIL_NO_RESPONSE: 503,
    MAIL_BAD_RESPONSE: 503,
    SETPROP_STATIC_FIELDS : 403,
    SETPROP_INTERNAL_FIELDS : 400,
    METASTORAGE_COMMIT_FAILED : 514,
    DSTORE_FILE_NOT_MATCH : 412,
    MOVE_SAME_RESOURCE : 409,
    COPY_SAME_RESOURCE : 409,
    SERVICE_NOT_FOUND : 404,
    HARDLINK_NOT_FOUND : 404,
    WH_RESOURCE_NOT_FOUND : 404,
    COPY_PARENT_NOT_FOUND : 409,
    NOT_FILE : 409,
    NOT_FOLDER : 409,
    PASSPORT_NO_RESPONSE : 503,
    PASSPORT_BAD_RESULT : 503,
    PASSPORT_UNKNOWN_UID: 422,
    FOTKI_NOT_FOUND : 404,
    GENERIC_ERROR_COPY : 409,
    FOLDER_NOT_FOUND : 404,
    FILE_NOT_FOUND : 404,
    RESOURCE_NOT_FOUND : 404,
    INVALID_RESOURCE_PATH: 400,
    FILE_EXISTS : 409,
    VERSION_NOT_FOUND : 404,
    NOT_FOUND : 404,
    OPERATION_NOT_FOUND : 404,
    KLADUN_OPERATION_NOT_FOUND : 404,
    KLADUN_HARDLINK_FOUND : 409,
    KLADUN_FILE_MODIFIED_BETWEEN_CALLBACKS: 409,
    HARDLINK_NOT_READY : 404,
    PATH_ERROR : 404,
    CLCK_NO_RESPONSE : 503,
    PUSH_NO_RESPONSE : 503,
    XIVA_BAD_TOKEN : 400,
    XIVA_LIMIT_EXCEEDED : 400,
    XIVA_APP_NOT_REGISTERED: 400,
    PERMISSION_DENIED : 403,
    RESOURCE_EXISTS : 409,
    SYMLINK_NOT_FOUND : 404,
    SYMLINK_NOT_ALLOWED : 409,
    SYMLINK_INVALID_PASSWORD: 403,
    DECRYPTION_ERROR : 404,
    OPERATION_CLASS_NOT_FOUND: 405,
    STORAGE_WRONG_VERSION : 409,
    RESOURCE_BLOCKED : 409,
    HID_BLOCKED : 409,
    KLADUN_CONFLICT : 409,
    EMPTY_FILE_UPLOADED_FOR_NON_EMPTY_STORE: 418,
    UPLOAD_FILE_SIZE_LIMIT_EXCEEDED: 413,
    UPLOAD_TRAFFIC_LIMIT_EXCEEDED: 423,
    UPLOAD_TRAFFIC_LIMIT_WITHOUT_DETAILS: 423,
    MPFS_TIMEOUT : 504,
    DOCVIEWER_UNSUPPORTED_TYPE : 403,
    DOCVIEWER_BAD_TOKEN : 403,
    SET_PUBLIC_NOT_FILE : 405,
    USER_INVITES_EXCEEDED : 405,
    PUBLICATION_ERROR : 424,
    STORAGE_ADDRESS_ERROR : 409,
    RESOURCE_LOCKED : 423,
    VIRAL_FILES_NOT_ALLOWED_TO_PUBLICATE : 406,
    GROUP_NOT_FOUND : 404,
    GROUP_CONFLICT : 409,
    GROUP_NOT_PERMIT : 409,
    GROUP_INVITE_NOT_FOUND : 404,
    GROUP_INVITE_EXPIRED : 409,
    GROUP_USER_INVITED : 409,
    VIRAL_FILES_NOT_ALLOWED_TO_PUBLICATE : 403,
    PASSPORT_PASSWORD_NEEDED : 409,
    PASSPORT_TOKEN_EXPIRED: 401,
    SOCIALPROXY_BAD_RESULT : 409,
    SOCIALPROXY_NO_RESPONSE : 409,
    PARTIAL_DIFF : 503,
    SIZE_NOT_FOUND: 503,
    WH_USER_NEED_INIT : 400,
    PRECONDITIONS_FAILED : 412,
    USER_BLOCKED: 403,
    SOCIALPROXY_NO_PROFILES : 404,
    DOCVIEWER_NOT_MODIFIED : 304,
    MOVE_PARENT_CHILD_RESOURCE : 409,
    GROUP_NOT_PERMIT : 403,
    MOVE_WRONG_DESTINATION : 403,
    USER_KARMA_WHITELIST : 403,
    USER_KARMA_BAD : 403,
    NO_FREE_SPACE_COPY_TO_DISK : 507,
    BROWSER_WRONG_TYPE : 409,
    BROWSER_NO_TYPE : 409,
    SYNC_STATE_NOT_FOUND : 404,
    SYNC_STATE_VERSION_MISMATCH: 409,
    COPY_INFECTED_FILE:409,
    BILLING_ORDER_NOT_FOUND : 404,
    BILLING_CLIENT_NOT_BINDED_TO_MARKET: 409,
    BILLING_SERVICE_NOT_FOUND: 404,
    WH_ERROR : 503,
    FEATURE_DISABLED: 403,
    SOCIALPROXY_INVALID_TOKEN: 401,
    KLADUN_UNEXPECTED_CALLBACK_STATE: 503,
    USER_READ_ONLY: 423,
    ALBUMS_IS_NOT_PUBLIC: 404,
    ALBUM_ITEM_MISSED: 404,
    ALBUMS_GET_BODY_EXPECTED: 400,
    ALBUMS_TOO_MANY_RESOURCES: 400,
    ALBUMS_INVALID_JSON_BODY: 400,
    ALBUMS_UNABLE_TO_DELETE: 403,
    ALBUMS_UNABLE_TO_PUBLISH_UNSAVED: 403,
    ALBUM_NOT_FOUND: 404,
    ALBUMS_UNABLE_TO_APPEND_ITEM: 404,
    ALBUM_ITEM_CAN_NOT_BE_MOVED: 410,

    SHARDS_NO_ALIVE_TO_REGISTER: 503,
    BAD_TARGET_USER_SPECIFIED: 409,
    USER_OVERDRAWN: 507,
    DEVICE_SUBSCRIPTION_NOT_FOUND: 404,

    OFFICE_UNAUTHORIZED: 401,
    OFFICE_UNSUPPORTED_ACTION: 405,
    OFFICE_UNSUPPORTED_EXTENSION: 415,
    OFFICE_BAD_RESOURCE_ID: 400,
    OFFICE_FILE_TOO_LARGE: 413,
    OFFICE_NO_HANDLER_FOUND: 404,
    OFFICE_IS_NOT_ALLOWED: 403,
    OFFICE_STORAGE_NOT_SUPPORTED: 409,
    OFFICE_PATH_NOT_SPECIFIED: 409,
    OFFICE_SERVICE_ID_NOT_SPECIFIED: 409,
    OFFICE_SERVICE_FILE_ID_NOT_SPECIFIED: 409,
    OFFICE_INVALID_PARAMETERS: 409,
    OFFICE_MAIL_ATTACHMENT_NOT_FOUND: 404,
    OFFICE_FILE_IS_READ_ONLY: 403,

    BROWSER_OUTDATED_VERSION: 409,
    BROWSER_OBJECT_NOT_FOUND: 404,

    OFFICE_NO_FREE_SPACE_KLADUN_ERROR: 409,
    OFFICE_SIZE_CONSTRAINT_FAILED_KLADUN_ERROR: 409,

    USER_REMOVE_NOT_ALLOWED: 403,
    SHARD_NOT_AVAILABLE: 503,
    USER_IS_NOT_B2B: 409,

    ENTITY_NOT_COMMENTED: 404,

    LENTA_LOADER_NO_RESPONSE: 500,
    LENTA_BAD_ARGUMENTS_UNHANDLED: 500,
    LENTA_EMPTY_BLOCK: 404,

    FORBIDDEN: 403,

    USER_IS_NOT_PDD: 409,

    REQUESTS_LIMIT_EXCEEDED: 503,
    REQUESTS_LIMIT_EXCEEDED_429: 429,

    USER_IS_NOT_YATEAM: 409,

    SUPPORT_TOO_MANY_USERS_WITH_PROHIBITED_CLEANING: 400,

    YATEAM_DIR_MODIFY_ERROR: 423,

    TVM_2_0_INVALID_TICKET: 401,
    TVM_2_0_CLIENT_NOT_REGISTERED: 401,
    UNAUTHORIZED: 401,
    API_RESTRICTED_FOR_OVERDRAFT_USER: 403,

    BAD_REQUEST_ERROR: 400,

    PASSPORT_UNSUPPORTED_EVENT_TYPE: 400,

    USER_INIT_LOCKED: 500,  # код 500 для того, чтобы клиенты поретраили user_init

    LIVE_PHOTO_NOT_FOUND: 409,
    LIVE_PHOTO_MULTIPLE_FOUND: 409,

    TOO_MANY_EXECUTING_OPERATIONS: 429,
    MD5_CHECK_NOT_SUPPORTED: 400,

    SPAM_ERROR: 400,

    USER_ALREADY_REINDEXED_FOR_QUICK_MOVE: 409,
    USER_CANNOT_BE_REINDEXED_FOR_QUICK_MOVE: 409,

    FILE_PRESENTED_IN_DELETION_LOG: 418,

    BULK_ACTIONS_LIMIT_EXCEEDED: 413,
    TOO_MANY_FILES_IN_LISTING: 429,
    BILLING_IN_APP_UID_MISMATCH: 400,
    FORBIDDEN_VIDEO_UNLIM: 402,

    VIDEO_STREAMING_UNPROCESSABLE_ENTITY: 422,
    OFFICE_ONLY_OFFICE_KEY_MISMATCH: 403,
    ONLINE_EDITOR_UNKNOW: 400,
    FOLDER_TOO_DEEP: 403,
    OVERDRAFT_USER_PUBLIC_LINK_IS_DISABLED: 404,
    PUBLIC_LINK_SETTINGS_IS_DISABLED: 404,
    OFFICE_ONLY_OFFICE_USER_LIMIT_REACHED: 413,
    OFFICE_ONLY_OFFICE_FILES_LIMIT_REACHED: 413,
    OFFICE_ONLY_OFFICE_PUBLIC_FILES_LIMIT_REACHED: 413,
    OFFICE_EDITOR_NOT_SUPPORTED_FOR_SHARED_EDIT: 409,
    OFFICE_REGION_NOT_SUPPORTED_FOR_SHARED_EDIT: 409,
    OFFICE_ONLY_OFFICE_OUTDATED_DATA: 409,
    OFFICE_INVALID_SELECTION_STRATEGY_PARAMETER: 400,
    OFFICE_EDITOR_LOCKED_FOR_SHARED_EDIT: 423,
    OFFICE_EDITOR_ON_PLATFORM_FORBIDDEN: 403,

    INTERNAL_ERROR: 500,
}

default_response = 500
default_caught_response = 409
default_apierror_response = 503
default_title = 'Unknown internal error'

PURPLE = "\n\033[95m%s\033[0m"
GRAY = "\033[90m%s\033[0m"
RED = "\033[91m%s\033[0m"
GREEN = "\033[92m%s\033[0m"

"""

Трактат о статусах и состояниях

В mpfs реально есть несколько статусов по загрузке:
    EXECUTING/WAITING - файл загружается
    DONE - файл сохранился в мульке и он есть в mpfs
    COMPLETED - к файлу прилетели все дополнительные метаданные (etime в том числе)

Когда-то давно мы по просьбе верстки сделали одинаковую внешнюю выдачу для статуса DONE и COMPLETED.
Поэтому для DONE и COMPLETED в поле "status" наружу отдается одно и то же значение DONE.

Теперь нам это мешает и мы вводим новое поле state, в котором будет НАСТОЯШЙ статус задачи.

Поэтому для обратной совмесимости есть:
    old_operation_titles - в нем старый dict
    true_operation_titles - новый dict

Еще информации: https://st.yandex-team.ru/CHEMODAN-20922

"""
old_operation_titles = {
    WAITING: 'WAITING',
    EXECUTING: 'EXECUTING',
    DONE: 'DONE',
    FAILED: 'FAILED',
    ABORTED: 'ABORTED',
    REJECTED: 'REJECTED',
    COMPLETED: 'DONE',
}

true_operation_titles = {
    WAITING: 'WAITING',
    EXECUTING: 'EXECUTING',
    DONE: 'DONE',
    FAILED: 'FAILED',
    ABORTED: 'ABORTED',
    REJECTED: 'REJECTED',
    COMPLETED: 'COMPLETED',
}
