# -*- coding: utf-8 -*-

'''PushNotifier'''
ALLOW = 'allow'
DENY = 'deny'
LOCALE = 'locale'
FORMAT = 'format'
TEMPLATE = 'template'
STOPCODE = 'stopcode'
CHANNEL  = 'channel'
RESOURCES = 'resources'

'''PushNotifier Classes'''
LOG    = 'log'
DIFF   = 'diff'
QUOTA  = 'quota'
INVITE = 'invite'
SPACE = 'space'
SPACE_GROUP = 'space_group'
PUSH_NAMESPACE = 'push'
SHARE_INVITE_NEW = 'share_invite_new'
SHARE_INVITE_APPROVED = 'share_invite_approved'
SHARE_INVITE_REJECTED = 'share_invite_rejected'
SHARE_INVITE_REMOVED = 'share_invite_removed'
SHARE_RIGHTS_CHANGED = 'share_rights_changed'
SHARE_USER_WAS_BANNED = 'share_user_was_banned'
SHARE_FOLDER_UNSHARED = 'share_folder_unshared'
SHARE_USER_HAS_LEFT = 'share_user_has_left'
SPACE_IS_LOW = 'space_is_low'
SPACE_IS_FULL = 'space_is_full'
ALBUMS = 'albums'
OPERATIONS = 'operations'
SERVICE_PROLONGATION = 'service_prolongation'


class Tag(object):
    klass = ''
    type = ''

    def __init__(self, **kw):
        for k,v in kw.iteritems():
            setattr(k, v)


class Low(Tag):
    klass = SPACE_IS_LOW
    type = 'is_low'
    template = 'space/fastFinished'


class Full(Tag):
    klass = SPACE_IS_FULL
    type = 'is_full'
    template = 'space/finished'
