# -*- coding: utf-8 -*-
from mpfs.common.util.ycrid_parser import YcridParser


class ActivityInfoPlatformFactory(object):
    YCRID_PREFIX_TO_PLATFORM_TYPE = {
        'rest_andr': 'android',
        'andr': 'android',
        'rest_ios': 'ios',
        'ios': 'ios',
        'win': 'windows',
        'rest_win': 'windows',
        'rest_mac': 'mac',
        'mac': 'mac',
        'public': 'web',
        'web': 'web',
    }

    @classmethod
    def build_by_ycrid(cls, ycrid):
        from mpfs.metastorage.postgres.schema import PlatformType
        ycrid_platform = YcridParser.get_platform(ycrid)
        raw_platform = cls.YCRID_PREFIX_TO_PLATFORM_TYPE.get(ycrid_platform)
        if raw_platform is None:
            return None
        return PlatformType(raw_platform)
