# -*- coding: utf-8 -*-
"""

MPFS
CORE

Шифрование через keyczar

"""

from keyczar import keyczar

from mpfs.common import errors
from mpfs.config import settings


KEYS_DIR = settings.system['fs_paths']['keys_dir']


class CryptAgentKeyczar(object):
    def __init__(self):
        self.crypter = keyczar.Crypter.Read(KEYS_DIR)

    def encrypt(self, data):
        '''
        Шифрование строки data
        '''
        return self.crypter.Encrypt(data)

    def decrypt(self, hsh):
        '''
        Дешифровка хеша
        '''
        try:
            return self.crypter.Decrypt(hsh)
        except Exception:
            raise errors.DecryptionError(hsh)
