# -*- coding: utf-8 -*-
"""
DEPRECATED

Не использовать
"""
import mpfs.engine.process


class DirectRSConnectionFabric(object):
    """Фабрика прямых соединений с репликасетами."""
    COLLECTION_UID_NAMES = {
        'user_index': '_id',
        'invite_mpfs_referrals': 'ref',
        'groups': 'owner',
    }

    def __init__(self):
        self._dbctl = mpfs.engine.process.dbctl()
        self._db = self._dbctl.database()

    def get_collection_for_q(self, collection_name, q):
        """
        Если запрос `q` выполняется только на одном шарде, то возвращает коллекцию напрямую соединённую с репликасетом
        содержащим этот шард. Иначе возвращается коллекция соединённая с монгосом.
        """
        if collection_name in ('changelog', 'operations', 'subscription'):
            return self._dbctl.database(collection_name)[collection_name]

        collection = self._db[collection_name]
        routed_collection = self._dbctl.mapper.route_collection(collection, [q])
        return routed_collection

    def get_collection_for_uid(self, collection_name, uid):
        """Возвращает коллекцию для uid'а по возможности соединённую напрямую с правильным репликасетом."""
        uid_name = self._get_collection_uid_name(collection_name)
        return self.get_collection_for_q(collection_name, {uid_name: uid})

    def _get_collection_uid_name(self, collection_name):
        return self.COLLECTION_UID_NAMES.get(collection_name) or 'uid'
